% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{tssim}
\alias{tssim}
\title{Simulate Data for Treatment Switching}
\usage{
tssim(
  tdxo = 0L,
  coxo = 1L,
  p_R = 0.5,
  p_X_1 = NA_real_,
  p_X_0 = NA_real_,
  rate_T = NA_real_,
  beta1 = NA_real_,
  beta2 = NA_real_,
  gamma0 = NA_real_,
  gamma1 = NA_real_,
  gamma2 = NA_real_,
  gamma3 = NA_real_,
  gamma4 = NA_real_,
  zeta0 = NA_real_,
  zeta1 = NA_real_,
  zeta2 = NA_real_,
  zeta3 = NA_real_,
  alpha0 = NA_real_,
  alpha1 = NA_real_,
  alpha2 = NA_real_,
  theta1_1 = NA_real_,
  theta1_0 = NA_real_,
  theta2 = NA_real_,
  rate_C = NA_real_,
  followup = NA_integer_,
  days = NA_integer_,
  n = NA_integer_,
  NSim = 1000L,
  seed = NA_integer_
)
}
\arguments{
\item{tdxo}{Logical indicator for timing of treatment switching:
\itemize{
\item 1: Treatment switching can occur at or after disease progression.
\item 0: Treatment switching is restricted to the time of disease
progression.
}}

\item{coxo}{Logical indicator for arm-specific treatment switching:
\itemize{
\item 1: Treatment switching occurs only in the control arm.
\item 0: Treatment switching is allowed in both arms.
}}

\item{p_R}{Probability of randomization to the experimental arm.}

\item{p_X_1}{Probability of poor baseline prognosis in the experimental
arm.}

\item{p_X_0}{Probability of poor baseline prognosis in the control arm.}

\item{rate_T}{Baseline hazard rate for time to death.}

\item{beta1}{Log hazard ratio for randomized treatment (\code{R}).}

\item{beta2}{Log hazard ratio for baseline covariate (\code{X}).}

\item{gamma0}{Intercept for the time-dependent covariate model (\code{L}).}

\item{gamma1}{Coefficient for lagged treatment switching (\code{Alag})
in the \code{L} model.}

\item{gamma2}{Coefficient for lagged \code{L} in the \code{L} model.}

\item{gamma3}{Coefficient for baseline covariate (\code{X}) in the
\code{L} model.}

\item{gamma4}{Coefficient for randomized treatment (\code{R}) in the
\code{L} model.}

\item{zeta0}{Intercept for the disease progression model (\code{Z}).}

\item{zeta1}{Coefficient for \code{L} in the \code{Z} model.}

\item{zeta2}{Coefficient for baseline covariate (\code{X}) in the
\code{Z} model.}

\item{zeta3}{Coefficient for randomized treatment (\code{R}) in the
\code{Z} model.}

\item{alpha0}{Intercept for the treatment switching model (\code{A}).}

\item{alpha1}{Coefficient for \code{L} in the \code{A} model.}

\item{alpha2}{Coefficient for baseline covariate (\code{X}) in the
\code{A} model.}

\item{theta1_1}{Negative log time ratio for \code{A} (experimental arm).}

\item{theta1_0}{Negative log time ratio for \code{A} (control arm).}

\item{theta2}{Negative log time ratio for \code{L}.}

\item{rate_C}{Hazard rate for random (dropout) censoring.}

\item{followup}{Number of treatment cycles per subject.}

\item{days}{Number of days in each treatment cycle.}

\item{n}{Number of subjects per simulation.}

\item{NSim}{Number of simulated datasets.}

\item{seed}{Random seed for reproducibility.}
}
\value{
A list of data frames, each containing simulated longitudinal and
event history data with the following variables:
\itemize{
\item \code{id}: Subject identifier.
\item \code{trtrand}: Randomized treatment assignment (0 = control,
1 = experimental)
\item \code{bprog}: Baseline prognosis (0 = good, 1 = poor).
\item \code{tpoint}: Treatment cycle index.
\item \code{tstart}: Start day of the treatment cycle.
\item \code{tstop}: End day of the treatment cycle.
\item \code{L}: Time-dependent covariate predicting survival and switching;
affected by treatment switching.
\item \code{Llag}: Lagged value of \code{L}.
\item \code{Z}: Disease progression status at \code{tstop}.
\item \code{A}: Treatment switching status at \code{tstop}.
\item \code{Alag}: Lagged value of \code{A}.
\item \code{Y}: Death indicator at \code{tstop}.
\item \code{timeOS}: Observed time to death or censoring.
\item \code{died}: Indicator of death by end of follow-up.
\item \code{progressed}: Indicator of disease progression by end of follow-up.
\item \code{timePD}: Observed time to progression or censoring.
\item \code{xo}: Indicator for whether treatment switching occurred.
\item \code{xotime}: Time of treatment switching (if applicable).
\item \code{censor_time}: Administrative censoring time.
}
}
\description{
Simulates data for studies involving treatment switching,
incorporating time-dependent confounding. The generated data can be used
to evaluate methods for handling treatment switching in survival analysis.
}
\details{
The simulation algorithm is adapted from Xu et al. (2022), by
simulating disease progression status and by using the multiplicative
effects of baseline and time-dependent covariates on survival time.
The design options \code{tdxo} and \code{coxo} indicate
the timing of treatment switching and the study arm eligibility
for switching, respectively. Each subject undergoes \code{followup}
treatment cycles until administrative censoring.
\enumerate{
\item At randomization, each subject is assigned treatment based on:
\deqn{R_i \sim \mbox{Bernoulli}(p_R)}
and a baseline covariate is generated:
\deqn{X_i \sim \mbox{Bernoulli}(p_{X_1} R_i + p_{X_0} (1-R_i))}

\item The initial survival time is drawn
from an exponential distribution with hazard:
\deqn{rate_T \exp(\beta_1 R_i + \beta_2 X_i)}
We define the event indicator at cycle \eqn{j} as
\deqn{Y_{i,j} = I(T_i \leq j\times days)}

\item The initial states are set to
\eqn{L_{i,0} = 0}, \eqn{Z_{i,0} = 0}, \eqn{Z_{i,0} = 0},
\eqn{Y_{i,0} = 0}. For each treatment cycle \eqn{j=1,\ldots,J},
we set \eqn{tstart = (j-1) \times days}.

\item Generate time-dependent covariates:
\deqn{\mbox{logit} P(L_{i,j}=1|\mbox{history}) = 
  \gamma_0 + \gamma_1 A_{i,j-1} + \gamma_2 L_{i,j-1} + 
  \gamma_3 X_i + \gamma_4 R_i}

\item If \eqn{T_i \leq j \times days}, set \eqn{tstop = T_i} and
\eqn{Y_{i,j} = 1}, which completes data generation
for subject \eqn{i}.

\item If \eqn{T_i > j \times days}, set \eqn{tstop = j\times days},
\eqn{Y_{i,j} = 0}, and perform the following before proceeding to
the next cycle for the subject.

\item Generate disease progression status:
If \eqn{Z_{i,j-1} = 0},
\deqn{\mbox{logit} P(Z_{i,j}=1 | \mbox{history}) = \zeta_0 + 
  \zeta_1 L_{i,j} + \zeta_2 X_i + \zeta_3 R_i}
Otherwise, set \eqn{Z_{i,j} = 1}.

\item Generate alternative therapy status:
If \eqn{A_{i,j-1} = 0}, determine switching eligibility
based on design options.
If switching is allowed:
\deqn{\mbox{logit} P(A_{i,j} = 1 | \mbox{history}) = \alpha_0 + 
  \alpha_1 L_{i,j} + \alpha_2 X_i}
If switching is now allowed, set \eqn{A_{i,j} = 0}.
If \eqn{A_{i,j-1} = 1}, set \eqn{A_{i,j} = 1} (once switched to
alternative therapy, remain on alternative therapy).

\item Update survival time based on changes in alternative
therapy status and time-dependent covariates:
\deqn{T_i = j\times days + (T_i - j\times days) \exp\{
  -(\theta_{1,1}R_i + \theta_{1,0}(1-R_i))(A_{i,j} - A_{i,j-1}) 
  -\theta_2 (L_{i,j} - L_{i,j-1})\}}
}

Additional random censoring times are generated from an exponential
distribution with hazard rate \eqn{rate_C}.

To estimate the true treatment effect in a Cox marginal
structural model, one can set \eqn{\alpha_0 = -\infty}, which
effectively forces \eqn{A_{i,j} = 0} (disabling treatment switching).
The coefficient for the randomized treatment can then be estimated
using a Cox proportional hazards model.
}
\examples{

simulated.data <- tssim(
  tdxo = 0, coxo = 0, p_R = 0.5, p_X_1 = 0.3, p_X_0 = 0.3, 
  rate_T = 0.002, beta1 = -0.5, beta2 = 0.3, 
  gamma0 = 0.3, gamma1 = -0.9, gamma2 = 0.7, gamma3 = 1.1, gamma4 = -0.8,
  zeta0 = -3.5, zeta1 = 0.5, zeta2 = 0.2, zeta3 = -0.4, 
  alpha0 = 0.5, alpha1 = 0.5, alpha2 = 0.4, 
  theta1_1 = -0.4, theta1_0 = -0.4, theta2 = 0.2,
  rate_C = 0.0000855, followup = 20, days = 30,
  n = 500, NSim = 100, seed = 314159)

}
\references{
Jessica G. Young, and Eric J. Tchetgen Tchetgen.
Simulation from a known Cox MSM using standard parametric models
for the g-formula.
Statistics in Medicine. 2014;33(6):1001-1014.

NR Latimer, IR White, K Tilling, and U Siebert.
Improved two-stage estimation to adjust for treatment switching in
randomised trials: g-estimation to address time-dependent confounding.
Statistical Methods in Medical Research. 2020;29(10):2900-2918.

Jing Xu, Guohui Liu, and Bingxia Wang.
Bias and type I error control in correcting treatment effect
for treatment switching using marginal structural models
in Phse III oncology trials.
Journal of Biopharmaceutical Statistics. 2022;32(6):897-914.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
