% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-TxpResult-plot.R
\name{TxpResult-plot}
\alias{TxpResult-plot}
\alias{plot}
\alias{plot,TxpResult,missing-method}
\alias{plot,TxpResult,numeric-method}
\title{Plot TxpResult objects}
\usage{
\S4method{plot}{TxpResult,missing}(
  x,
  package = c("grid", "ggplot2"),
  fills = NULL,
  showScore = TRUE,
  gp = NULL,
  vp = NULL,
  name = NULL,
  newpage = TRUE,
  ...,
  ncol = NULL,
  bgColor = "grey80",
  borderColor = "white",
  sliceBorderColor = "white",
  sliceValueColor = NULL,
  sliceLineColor = NULL,
  showMissing = TRUE,
  showCenter = TRUE
)

\S4method{plot}{TxpResult,numeric}(
  x,
  y,
  labels = NULL,
  newpage = TRUE,
  margins = c(4, 0, 1, 1),
  name = NULL,
  gp = NULL,
  vp = NULL,
  ...
)
}
\arguments{
\item{x}{\link{TxpResult} object}

\item{package}{Character scalar, choice of "grid" or "ggplot2" for plotting
ToxPi profiles}

\item{fills}{Vector of colors to fill slices. Set to NULL to use default}

\item{showScore}{Logical scalar, overall score printed below the name when
\code{TRUE}}

\item{gp, vp, name}{Passed to \link[grid:grid.frame]{grid::frameGrob} when creating the plotting
area}

\item{newpage}{Logical scalar, \link[grid:grid.newpage]{grid::grid.newpage} called prior to plotting
when \code{TRUE}}

\item{...}{Passed to \link{pieGridGrob} when plotting ToxPi and to pointsGrob
when plotting ranks}

\item{ncol}{Number of columns for ggplot2 ToxPi profiles}

\item{bgColor, borderColor, sliceBorderColor, sliceValueColor, sliceLineColor}{Various color options when creating ggplot2 ToxPi profiles. Set to NULL
for no color}

\item{showMissing}{Boolean for coloring data missingness in ggplot2
ToxPi profiles}

\item{showCenter}{Boolean for showing inner circle in ggplot2 ToxPi
profiles. When set to False overrides showMissing}

\item{y}{Rank vector, i.e. \code{txpRanks(x)}}

\item{labels}{Integer vector, indices of \code{x} to label in the rank plot}

\item{margins}{Passed to \link[grid:plotViewport]{grid::plotViewport}; only affects the scatterplot
region margins}
}
\value{
No return value when using grid; called for side effect (i.e.
drawing in current graphics device). Will return ggplot2 object otherwise.
}
\description{
Plot \link{TxpResult} objects
}
\details{
It is strongly recommended to use a specific device (e.g., \link[grDevices:png]{grDevices::png},
\link[grDevices:pdf]{grDevices::pdf}) when creating rank plots.
Using a GUI device will likely lead to inaccurate labeling, and any changes
to the device size WILL lead to inaccurate labeling.

The plotting is built on the \link[grid:grid-package]{grid::grid-package}, and can be adjusted or
edited as such.

If the labels are running of the device, the top or bottom margins can be
increased with the \code{margins} parameter.

ToxPi profiles can also be plotted using the ggplot2 package.
}
\section{Functions}{
\itemize{
\item \code{plot(x = TxpResult, y = missing)}: Plot ToxPi diagrams

\item \code{plot(x = TxpResult, y = numeric)}: Plot ToxPi ranks

}}
\examples{
## Load example dataset & model; see ?TxpModel for building model objects
data(txp_example_input, package = "toxpiR")
data(txp_example_model, package = "toxpiR")

## Calculate scores for single model; returns TxpResult object
res <- txpCalculateScores(model = txp_example_model, 
                          input = txp_example_input, 
                          id.var = "name")

library(grid)
plot(res)
plot(res[order(txpRanks(res))[1:4]])

library(ggplot2)
plot(res, package = "gg")
plot(res[order(txpRanks(res))], package = "gg", ncol = 5) +
  theme(legend.position = "bottom")

plot(res, txpRanks(res))
plot(res, txpRanks(res), pch = 16, size = unit(0.75, "char"))

## Will likely make inaccurate labels within a GUI, e.g. RStudio
## use png, pdf, etc. to get accurate labels
\dontrun{
tmpPdf <- tempfile()
pdf(tmpPdf)
plot(res, txpRanks(res), labels = c(10, 4, 2), pch = 16)
dev.off()
}

}
