% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{create_topolow_map}
\alias{create_topolow_map}
\title{Main TopoLow algorithm implementation (DEPRECATED)}
\usage{
create_topolow_map(
  distance_matrix,
  ndim,
  mapping_max_iter = 1000,
  k0,
  cooling_rate,
  c_repulsion,
  relative_epsilon = 1e-04,
  convergence_counter = 3,
  initial_positions = NULL,
  write_positions_to_csv = FALSE,
  output_dir,
  verbose = FALSE
)
}
\arguments{
\item{distance_matrix}{Matrix. Square, symmetric distance matrix. Can contain NA values
for missing measurements and character strings with < or > prefixes for thresholded
measurements.}

\item{ndim}{Integer. Number of dimensions for the embedding space.}

\item{mapping_max_iter}{Integer. Maximum number of map optimization iterations.}

\item{k0}{Numeric. Initial spring constant controlling spring forces.}

\item{cooling_rate}{Numeric. Rate of spring constant decay per iteration (0 < cooling_rate < 1).}

\item{c_repulsion}{Numeric. Repulsion constant controlling repulsive forces.}

\item{relative_epsilon}{Numeric. Convergence threshold for relative change in error.
Default is 1e-4.}

\item{convergence_counter}{Integer. Number of iterations below threshold before declaring
convergence. Default is 5.}

\item{initial_positions}{Matrix or NULL. Optional starting coordinates. If NULL,
random initialization is used. Matrix should have nrow = nrow(distance_matrix)
and ncol = ndim.}

\item{write_positions_to_csv}{Logical. Whether to save point positions to CSV file.
Default is FALSE.}

\item{output_dir}{Character. Directory to save CSV file. Required if
\code{write_positions_to_csv} is TRUE.}

\item{verbose}{Logical. Whether to print progress messages. Default is FALSE.}
}
\value{
A \code{list} object of class \code{topolow}. This list contains the results of the
optimization and includes the following components:
\itemize{
\item \code{positions}: A \code{matrix} of the optimized point coordinates in the n-dimensional space.
\item \code{est_distances}: A \code{matrix} of the Euclidean distances between points in the final optimized configuration.
\item \code{mae}: The final Mean Absolute Error between the target distances and the estimated distances.
\item \code{iter}: The total number of iterations performed before the algorithm terminated.
\item \code{parameters}: A \code{list} containing the input parameters used for the optimization run.
\item \code{convergence}: A \code{list} containing the final convergence status, including a logical \code{achieved} flag and the final \code{error} value.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{create_topolow_map()} was deprecated in version 2.0.0 and will be removed in
a future version. Please use \code{\link[=euclidean_embedding]{euclidean_embedding()}} instead, which provides
the same functionality with improved performance and additional features.
}
\details{
This function has been superseded by \code{\link[=euclidean_embedding]{euclidean_embedding()}}, which offers:
\itemize{
\item Enhanced matrix reordering for better optimization
\item Improved parameter validation with informative warnings
\item Consistent naming convention (dissimilarity vs distance)
\item Better documentation and examples
}

The core algorithm remains identical, ensuring your results will be equivalent.
The main changes are:
\itemize{
\item Parameter name: \code{distance_matrix} --> \code{dissimilarity_matrix}
\item Function name: \code{create_topolow_map()} --> \code{euclidean_embedding()}
}
}
\examples{
\donttest{
# Simple example (deprecated - use euclidean_embedding() instead)
dist_mat <- matrix(c(0, 2, 3, 2, 0, 4, 3, 4, 0), nrow=3)

# This will generate a deprecation warning
result <- create_topolow_map(
  dist_mat, 
  ndim = 2, 
  mapping_max_iter = 100,
  k0 = 1.0, 
  cooling_rate = 0.001, 
  c_repulsion = 0.01, 
  verbose = FALSE
)

# Recommended approach with new function:
result_new <- euclidean_embedding(
  dissimilarity_matrix = dist_mat,
  ndim = 2,
  mapping_max_iter = 100,
  k0 = 1.0,
  cooling_rate = 0.001,
  c_repulsion = 0.01,
  verbose = FALSE
)
}

}
\seealso{
\code{\link[=euclidean_embedding]{euclidean_embedding()}} for the replacement function.
}
\keyword{internal}
