% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmvt.R
\name{rtmvt}
\alias{rtmvt}
\title{Random Generation for Truncated Multivariate t}
\usage{
rtmvt(
  mean,
  sigma,
  nu,
  blc = NULL,
  lower,
  upper,
  init = NULL,
  burn = 10,
  n = NULL
)
}
\arguments{
\item{mean}{\code{n x p} matrix of means. The number of rows is the number 
of observations. The number of columns is the dimension of the problem.}

\item{sigma}{\code{p x p} covariance matrix.}

\item{nu}{degrees of freedom for Student-t distribution.}

\item{blc}{\code{m x p} matrix of coefficients for linear inequality 
constraints. If \code{NULL}, the \code{p x p} identity matrix will be used.}

\item{lower}{\code{n x m} or \code{1 x m} matrix of lower bounds for 
truncation.}

\item{upper}{\code{n x m} or \code{1 x m} matrix of upper bounds for 
truncation.}

\item{init}{\code{n x p} or \code{1 x p} matrix of initial values. 
If \code{NULL}, default initial values will be generated.}

\item{burn}{number of burn-in iterations. Defaults to 10.}

\item{n}{number of random samples when \code{mean} is a vector.}
}
\value{
Returns an \code{n x p} matrix of random numbers following the 
  specified truncated multivariate t distribution.
}
\description{
Draws from truncated multivariate t distribution subject to 
linear inequality constraints represented by a matrix.
}
\examples{
# Example 1: full rank blc
d = 3;
rho = 0.5;
sigma = matrix(0, d, d);
sigma = rho^abs(row(sigma) - col(sigma));
nu = 10;
blc = diag(1,d);
n = 1000;
mean = matrix(rep(1:d,n), nrow=n, ncol=d, byrow=TRUE);
set.seed(1203)
result = rtmvt(mean, sigma, nu, blc, -1, 1, burn=50)
apply(result, 2, summary)

# Example 2: use the alternative form of input
set.seed(1203)
result = rtmvt(mean=1:d, sigma, nu, blc, -1, 1, burn=50, n)
apply(result, 2, summary)

# Example 3: non-full rank blc, different means
d = 3;
rho = 0.5;
sigma = matrix(0, d, d);
sigma = rho^abs(row(sigma) - col(sigma));
nu = 10;
blc = matrix(c(1,0,1,1,1,0), nrow=d-1, ncol=d, byrow=TRUE)
n = 100;
set.seed(3084)
mean = matrix(runif(n*d), nrow=n, ncol=d);
result = rtmvt(mean, sigma, nu, blc, -1, 1, burn=50)
apply(result, 2, summary)

}
