% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimension-reduction.R
\name{dimension_reduction}
\alias{dimension_reduction}
\alias{aggregate_linear}
\alias{aggregate_geometrical}
\alias{aggregate_manual}
\title{The dimension reduction module}
\usage{
dimension_reduction(data, ...)

aggregate_linear(formula, weight)

aggregate_geometrical(formula)

aggregate_manual(formula)
}
\arguments{
\item{data}{used in \code{dimension_reduction()}, an \code{idx_tbl} object,
see [tidyindex::init()]}

\item{...}{used in \code{dimension_reduction()}, a dimension reduction
object of \code{dim_red} class, currently one of \code{aggregate_linear()},
\code{aggregate_geometrical()}, or \code{aggregate_manual()}.}

\item{formula}{the formula to evaluate}

\item{weight}{used in \code{aggregate_linear()}, the column of the
linear weights from the \code{roles} element in an index table object.
See [tidyindex::add_paras()]}
}
\value{
an index table object
}
\description{
The module combines multiple variables into a new variable. The new variable
can be a linear combination of the original variables,
\code{aggregate_linear()}, or a geometric mean of the original variables,
\code{aggregate_geometry()}, or created from an user formula input,
\code{aggregate_manual()}.
}
\examples{
dt <- gggi |>
  dplyr::select(country, sex_ratio_at_birth:healthy_life_expectancy) |>
  init()

dt |>
  dimension_reduction(health = aggregate_manual(
    ~sex_ratio_at_birth * 0.693 + healthy_life_expectancy * 0.307))
dt |>
  add_paras(gggi_weights, by = variable) |>
  dimension_reduction(health = aggregate_linear(
    ~sex_ratio_at_birth:healthy_life_expectancy, weight = var_weight))
dt |>
  dimension_reduction(health = aggregate_geometrical(
    ~sex_ratio_at_birth:healthy_life_expectancy)
  )

}
