% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplPrepOtpt.R
\name{tcplPrepOtpt}
\alias{tcplPrepOtpt}
\title{Map assay/chemical ID values to annotation information}
\usage{
tcplPrepOtpt(dat, ids = NULL)
}
\arguments{
\item{dat}{data.table, output from \code{\link{tcplLoadData}}}

\item{ids}{Character, (optional) a subset of ID fields to map}
}
\value{
The given data.table with chemical and assay information mapped
}
\description{
\code{tcplPrepOtpt} queries the chemical and assay information from the tcpl
database, and maps the annotation information to the given data.
}
\details{
\code{tcplPrepOtpt} is used to map chemical and assay identifiers to their
respective names and annotation information to create a human-readable table
that is more suitable for an export/output.

By default the function will map sample ID (spid), assay component id (acid),
and assay endpoint ID (aeid) values. However, if 'ids' is not null, the 
function will only attempt to map the ID fields given by 'ids.'
}
\examples{
\dontrun{
## Load some example data
d1 <- tcplLoadData(1)

## Check for chemical name in 'dat'
"chnm" \%in\% names(d1) ## FALSE

#' ## Map all annotations 
d2 <- tcplPrepOtpt(d1) ##
"chnm" \%in\% names(d2) ## TRUE
"acnm" \%in\% names(d2) ## TRUE
 
## Map chemical annotation only
d3 <- tcplPrepOtpt(d1, ids = "spid")
"chnm" \%in\% names(d3) ## TRUE
"acnm" \%in\% names(d3) ## FALSE
}

}
