% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner.R
\name{learner}
\alias{learner}
\title{R6 class for prediction models}
\description{
Interface for statistical and machine learning models to be used
for nuisance model estimation in targeted learning.

The following list provides an overview of constructors for many commonly
used models.

Regression and classification: \link{learner_glm}, \link{learner_gam}, \link{learner_grf},
\link{learner_hal}, \link{learner_glmnet_cv}, \link{learner_svm}, \link{learner_xgboost},
\link{learner_mars} \cr
Regression: \link{learner_isoreg} \cr
Classification: \link{learner_naivebayes} \cr
Ensemble (super learner): \link{learner_sl}
}
\examples{
data(iris)
rf <- function(formula, ...) {
  learner$new(formula,
    info = "grf::probability_forest",
    estimate = function(x, y, ...) {
      grf::probability_forest(X = x, Y = y, ...)
    },
    predict = function(object, newdata) {
      predict(object, newdata)$predictions
    },
    estimate.args = list(...)
  )
}

args <- expand.list(
  num.trees = c(100, 200), mtry = 1:3,
  formula = c(Species ~ ., Species ~ Sepal.Length + Sepal.Width)
)
models <- lapply(args, function(par) do.call(rf, par))

x <- models[[1]]$clone()
x$estimate(iris)
predict(x, newdata = head(iris))

\donttest{
# Reduce Ex. timing
a <- targeted::cv(models, data = iris)
cbind(coef(a), attr(args, "table"))
}

# defining learner via function with arguments y (response)
# and x (design matrix)
f1 <- learner$new(
  estimate = function(y, x) lm.fit(x = x, y = y),
  predict = function(object, newdata) newdata \%*\% object$coefficients
)
# defining the learner via arguments formula and data
f2 <- learner$new(
  estimate = function(formula, data, ...) glm(formula, data, ...)
)
# generic learner defined from function (predict method derived per default
# from stats::predict
f3 <- learner$new(
  estimate = function(dt, ...) {
    lm(y ~ x, data = dt)
  }
)

## ------------------------------------------------
## Method `learner$summary`
## ------------------------------------------------

lr <- learner_glm(y ~ x, family = "nb")
lr$summary()

lr_sum <- lr$summary() # store returned summary in new object
names(lr_sum)
print(lr_sum)
}
\author{
Klaus Kähler Holst, Benedikt Sommer
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{info}}{Optional information/name of the model}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{clear}}{Remove fitted model from the learner object}

\item{\code{fit}}{Return estimated model object.}

\item{\code{formula}}{Return model formula. Use \link[=learner]{learner$update()} to
update the formula.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-learner-new}{\code{learner$new()}}
\item \href{#method-learner-estimate}{\code{learner$estimate()}}
\item \href{#method-learner-predict}{\code{learner$predict()}}
\item \href{#method-learner-update}{\code{learner$update()}}
\item \href{#method-learner-print}{\code{learner$print()}}
\item \href{#method-learner-summary}{\code{learner$summary()}}
\item \href{#method-learner-response}{\code{learner$response()}}
\item \href{#method-learner-design}{\code{learner$design()}}
\item \href{#method-learner-opt}{\code{learner$opt()}}
\item \href{#method-learner-clone}{\code{learner$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-learner-new"></a>}}
\if{latex}{\out{\hypertarget{method-learner-new}{}}}
\subsection{Method \code{new()}}{
Create a new prediction model object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{learner$new(
  formula = NULL,
  estimate,
  predict = stats::predict,
  predict.args = NULL,
  estimate.args = NULL,
  info = NULL,
  specials = c(),
  formula.keep.specials = FALSE,
  intercept = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{formula}}{formula specifying outcome and design matrix}

\item{\code{estimate}}{function for fitting the model. This must be a function
with response, 'y', and design matrix, 'x'. Alternatively, a function
with a formula and data argument. See the examples section.}

\item{\code{predict}}{prediction function (must be a function of model
object, 'object', and new design matrix, 'newdata')}

\item{\code{predict.args}}{optional arguments to prediction function}

\item{\code{estimate.args}}{optional arguments to estimate function}

\item{\code{info}}{optional description of the model}

\item{\code{specials}}{optional specials terms (weights, offset,
id, subset, ...) passed on to \link{design}}

\item{\code{formula.keep.specials}}{if TRUE then special terms defined by
\code{specials} will be removed from the formula before it is being passed to
the estimate print.function()}

\item{\code{intercept}}{(logical) include intercept in design matrix}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-learner-estimate"></a>}}
\if{latex}{\out{\hypertarget{method-learner-estimate}{}}}
\subsection{Method \code{estimate()}}{
Estimation method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{learner$estimate(data, ..., store = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{data.frame}

\item{\code{...}}{Additional arguments to estimation method}

\item{\code{store}}{Logical determining if estimated model should be
stored inside the class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-learner-predict"></a>}}
\if{latex}{\out{\hypertarget{method-learner-predict}{}}}
\subsection{Method \code{predict()}}{
Prediction method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{learner$predict(newdata, ..., object = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newdata}}{data.frame}

\item{\code{...}}{Additional arguments to prediction method}

\item{\code{object}}{Optional model fit object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-learner-update"></a>}}
\if{latex}{\out{\hypertarget{method-learner-update}{}}}
\subsection{Method \code{update()}}{
Update formula
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{learner$update(formula)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{formula}}{formula or character which defines the new response}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-learner-print"></a>}}
\if{latex}{\out{\hypertarget{method-learner-print}{}}}
\subsection{Method \code{print()}}{
Print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{learner$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-learner-summary"></a>}}
\if{latex}{\out{\hypertarget{method-learner-summary}{}}}
\subsection{Method \code{summary()}}{
Summary method to provide more extensive information than
\link[=learner]{learner$print()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{learner$summary()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
summarized_learner object, which is a list with the following
elements:
\describe{
\item{info}{description of the learner}
\item{formula}{formula specifying outcome and design matrix}
\item{estimate}{function for fitting the model}
\item{estimate.args}{arguments to estimate function}
\item{predict}{function for making predictions from fitted model}
\item{predict.args}{arguments to predict function}
\item{specials}{provided special terms}
\item{intercept}{include intercept in design matrix}
}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{lr <- learner_glm(y ~ x, family = "nb")
lr$summary()

lr_sum <- lr$summary() # store returned summary in new object
names(lr_sum)
print(lr_sum)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-learner-response"></a>}}
\if{latex}{\out{\hypertarget{method-learner-response}{}}}
\subsection{Method \code{response()}}{
Extract response from data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{learner$response(data, eval = TRUE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{data.frame}

\item{\code{eval}}{when FALSE return the untransformed outcome
(i.e., return 'a' if formula defined as I(a==1) ~ ...)}

\item{\code{...}}{additional arguments to \link{design}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-learner-design"></a>}}
\if{latex}{\out{\hypertarget{method-learner-design}{}}}
\subsection{Method \code{design()}}{
Generate \link{design} object (design matrix and response) from data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{learner$design(data, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{data.frame}

\item{\code{...}}{additional arguments to \link{design}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-learner-opt"></a>}}
\if{latex}{\out{\hypertarget{method-learner-opt}{}}}
\subsection{Method \code{opt()}}{
Get options
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{learner$opt(arg)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{arg}}{name of option to get value of}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-learner-clone"></a>}}
\if{latex}{\out{\hypertarget{method-learner-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{learner$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
