% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wheat.R
\docType{data}
\name{wheat}
\alias{wheat}
\title{Wheat Kernels}
\format{
The data frame has 275 rows and 7 variables:
\describe{
 \item{class}{hrw = hard red winter wheat and srw = soft red winter wheat.}
\item{density}{Density of a kernel.}
\item{hardness}{Hardness of a kernel.}
\item{size}{Size of a kernel.}
\item{weight}{Weight of a kernel.}
\item{moisture}{Moisture content of a kernel.}
\item{type}{Kernel's condition: Healthy, Sprout (sprouted prematurely), or
Scab (infected with a fungus).}
}
}
\usage{
data(wheat)
}
\description{
Data.frame
}
\details{
A study on kernels of wheat was done.
There are two classes of wheat: hard and soft red winter wheat.
Each kernel measured for density, hardness, size, weight, and moisture content.
Each kernel was classified by visual inspection if healthy, sprouted, or scab.
A row in the data frame represents a kernel of wheat.
}
\examples{
data("wheat", package='syllogi')
str(wheat)
}
\references{
Bilder, C.R., & Loughin, T.M. (2014). Analysis of Categorical Data with R (1st ed.). Chapman and Hall/CRC. https://doi.org/10.1201/b17211

Martin, C., Herrman, T.J., Loughin, T. and Oentong, S. (1998), Micropycnometer Measurement of Single-Kernel Density of Healthy, Sprouted, and Scab\-Damaged Wheats†. Cereal Chemistry, 75: 177-180. https://doi-org.libproxy.uwyo.edu/10.1094/CCHEM.1998.75.2.177
}
\keyword{data}
