% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functionsPlotting_corset.R
\name{superbPlot.corset}
\alias{superbPlot.corset}
\title{superbPlot 'corset' layout}
\usage{
superbPlot.corset(
  summarydata,
  xfactor,
  groupingfactor,
  addfactors,
  rawdata = NULL,
  lineParams = list(),
  pointParams = list(),
  errorbarParams = list(),
  jitterParams = list(),
  violinParams = list(),
  facetParams = list(),
  xAsFactor = TRUE
)
}
\arguments{
\item{summarydata}{a data.frame with columns "center", "lowerwidth" and "upperwidth" for each level of the factors;}

\item{xfactor}{a string with the name of the column where the factor going on the horizontal axis is given;}

\item{groupingfactor}{a string with the name of the column for which the data will be grouped on the plot;}

\item{addfactors}{a string with up to two additional factors to make the rows and columns panels, in the form "fact1 ~ fact2";}

\item{rawdata}{always contains "DV" for each participants and each level of the factors;}

\item{lineParams}{(optional) list of graphic directives that are sent to the geom_line layer;}

\item{pointParams}{(optional) list of graphic directives that are sent to the geom_bar layer;}

\item{errorbarParams}{(optional) list of graphic directives that are sent to the geom_superberrorbar layer;}

\item{jitterParams}{(optional) list of graphic directives that are sent to the geom_jitter layer;}

\item{violinParams}{(optional) list of graphic directives that are sent to the geom_boxplot layer;}

\item{facetParams}{(optional) list of graphic directives that are sent to the facet_grid layer;}

\item{xAsFactor}{(optional) Boolean to indicate if the factor on the horizontal should continuous or discrete (default is discrete).}
}
\value{
a ggplot object
}
\description{
superbPlot comes with a few built-in templates for making the final plots.
The corset plot is specifically devised for 2-repeated-measure design: it merges
the "pointindividualline" layout with a raincloud layout \insertCite{kb21}{superb}.
All layout produces ggplot objects that can be further customized. Additionally, it is
possible to create custom-make templates (see vignette 5). The functions, to be
"superbPlot-compatible", must have these parameters:
}
\examples{
# We first generate randomly a 2-measurement dataset with 50 participants and a large effect
dta <- GRD(SubjectsPerGroup = 50, WSFactors = "moment(2)", Effects = list("moment"=slope(3)))

# This will make a basic corset plot 
superb(
   cbind(DV.1, DV.2) ~ .,
   dta, 
   WSFactors = "moment(2)", 
   plotStyle = "corset" 
)

# This will color the increasing and decreasing individuals
superb(
   cbind(DV.1, DV.2) ~ ., 
   dta, 
   WSFactors = "moment(2)", 
   plotStyle = "corset",
   lineParams = list(colorize=TRUE) 
)

# This layout has similarities with the "pointindividualline" layout
superb(
   cbind(DV.1, DV.2) ~ ., 
   dta, 
   WSFactors = "moment(2)", 
   plotStyle = "pointindividualline" 
)

# if you extract the data with superbData, you can 
# run this layout directly
processedData <- superb(
   cbind(DV.1, DV.2) ~ ., 
   dta, 
   WSFactors = "moment(2)", 
   showPlot  = FALSE
)

superbPlot.corset(processedData$summaryStatistic, 
   "moment", NULL, ".~.", 
   processedData$rawData, 
   lineParams = list(colorize=TRUE) )


}
\references{
\insertAllCited{}
}
