% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest.R
\name{stylerignore}
\alias{stylerignore}
\title{Turn off styling for parts of the code}
\description{
Using stylerignore markers, you can temporarily turn off styler. Beware that
for \verb{styler > 1.2.0}, some alignment is
\href{https://styler.r-lib.org/articles/detect-alignment.html}{detected by styler},
making stylerignore redundant. See a few illustrative examples below.
}
\details{
Styling is on for all lines by default when you run styler.
\itemize{
\item To mark the start of a sequence where you want to turn styling off, use
\verb{# styler: off}.
\item To mark the end of this sequence, put \verb{# styler: on} in your code. After
that line, styler will again format your code.
\item To ignore an inline statement (i.e. just one line), place \verb{# styler: off}
at the end of the line.
To use something else as start and stop markers, set the R options
\code{styler.ignore_start} and
\code{styler.ignore_stop} using \code{\link[=options]{options()}}. For styler version > 1.6.2, the
option supports character vectors longer than one and the marker are not
exactly matched, but using a  regular expression, which means you can have
multiple marker on one line, e.g. \verb{# nolint start styler: off}.
}
}
\examples{
# as long as the order of the markers is correct, the lines are ignored.
style_text(
  "
  1+1
  # styler: off
  1+1
  # styler: on
  1+1
  "
)

# if there is a stop marker before a start marker, styler won't be able
# to figure out which lines you want to ignore and won't ignore anything,
# issuing a warning.
\dontrun{
style_text(
  "
  1+1
  # styler: off
  1+1
  # styler: off
  1+1
  "
)
}
# some alignment of code is detected, so you don't need to use stylerignore
style_text(
  "call(
    xyz =  3,
    x   = 11
  )"
)
}
