% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.tpp.R
\name{density.tpp}
\alias{density.tpp}
\title{Kernel estimation of intensity of one-dimensional point patterns}
\usage{
\method{density}{tpp}(x,tbw,at=c("points","pixels"),...)
}
\arguments{
\item{x}{an object of class \code{\link{tpp}}}

\item{tbw}{time smoothing bandwidth}

\item{at}{string specifying whether to compute the intensity values at a grid of pixel locations (at="pixels") or only at the points of x (at="points"). default is to estimate the intensity at pixels}

\item{...}{arguments passed to \link[stats]{density}}
}
\value{
If \code{at="points"}: a vector of intensity values at the data points of x.

If \code{at="pixels"}: a vector of intensity values over a grid.
}
\description{
Kernel estimation of intensity of one-dimensional point patterns.
}
\details{
A vector of intensity values.
}
\examples{
 
X <- tpp(sample(c(1:24),200,replace = TRUE))
plot(density(X))


}
\references{
Mateu, J., Moradi, M., & Cronie, O. (2019). Spatio-temporal point patterns on linear networks: Pseudo-separable intensity estimation. Spatial Statistics, 100400.
}
\seealso{
\code{\link{density}}, \code{\link{bw.nrd0}}
}
\author{
Mehdi Moradi <m2.moradi@yahoo.com> and Ottmar Cronie
}
