% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSLorentz.R
\name{SSlorentz}
\alias{SSlorentz}
\alias{lorentz.3.fun}
\alias{lorentz.4.fun}
\alias{NLS.lorentz.3}
\alias{NLS.lorentz.4}
\alias{DRC.lorentz.3}
\alias{DRC.lorentz.4}
\title{Lorentz equation}
\usage{
lorentz.3.fun(X, b, d, e)
lorentz.4.fun(X, b, c, d, e)
NLS.lorentz.3(X, b, d, e)
NLS.lorentz.4(X, b, c, d, e)
DRC.lorentz.3()
DRC.lorentz.4()
}
\arguments{
\item{X}{a numeric vector of values at which to evaluate the model}

\item{b}{model parameter}

\item{d}{model parameter}

\item{e}{model parameter}

\item{c}{model parameter}
}
\value{
lorentz.3.fun(), lorentz.4.fun(), NLS.lorentz.3() and NLS.lorentz.4() return a numeric value,
while DRC.lorentz.3() and DRC.lorentz.4()  returns a list containing
the nonlinear function, the self starter function and the parameter names.
}
\description{
These functions provide the Lorentz equation with 3 and 4 parameters ('lorentz.3.fun()'
and 'lorentz.4.fun()' ), as well as the self-starters for the \code{\link{nls}}
function ( 'NLS.lorentz.3()' and 'NLS.lorentz.4()') and for the
\code{\link[drc]{drm}} function in the 'drc' package ('DRC.lorentz.3()' and 'DRC.lorentz.4()')
}
\details{
These functions provide the Lorentz equation, that is a bell-shaped
curve similar to a gaussian density function. It is parameterised as:

\deqn{ f(x) = c + \frac{d - c} {( 1 + b \, (X - e)^2) } }

The parameter 'e' represents the abscissa of the maximum value,
while c is the minimum (asymptotic) response value and d is the maximum
response value. The parameter 'b' relates to the slope at inflection
point. For the 3-parameters curve, c is equal to 0.
}
\examples{

X <- c(5, 10, 15, 20, 25, 30, 35, 40, 45, 50)
Y1 <- c(0.1, 2, 5.7, 9.3, 19.7, 28.4, 20.3, 6.6, 1.3, 0.1)
Y2 <- Y1 + 2

# nls fit
mod.nls <- nls(Y1 ~ NLS.lorentz.3(X, b, d, e) )
mod.nls2 <- nls(Y2 ~ NLS.lorentz.4(X, b, c, d, e) )

# drm fit
mod.drc <- drm(Y1 ~ X, fct = DRC.lorentz.3() )
mod.drc2 <- drm(Y2 ~ X, fct = DRC.lorentz.4() )
plot(mod.drc, ylim = c(0, 30), log = "")
plot(mod.drc2, add = TRUE, col = "red")


}
\references{
Ratkowsky, DA (1990) Handbook of nonlinear regression models. New York (USA): Marcel Dekker Inc.

Onofri, A. (2020). A collection of self-starters for nonlinear regression in R. See: \url{https://www.statforbiology.com/2020/stat_nls_usefulfunctions/}
}
\author{
Andrea Onofri
}
