% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{regime_distance}
\alias{regime_distance}
\title{Calculate "distance" between two (scaled) regimes
 \strong{\eqn{\upsilon_{m}}}\eqn{ = (\phi_{m},}\strong{\eqn{\phi_{m}}}\eqn{,\sigma_{m})}}
\usage{
regime_distance(regime_pars1, regime_pars2)
}
\arguments{
\item{regime_pars1}{a length \eqn{pd^2+d+d(d+1)/2} vector
\strong{\eqn{\upsilon_{m}}}\eqn{ = (\phi_{m},}\strong{\eqn{\phi_{m}}}\eqn{,\sigma_{m})}.}

\item{regime_pars2}{a length \eqn{pd^2+d+d(d+1)/2} vector
\strong{\eqn{\upsilon_{m}}}\eqn{ = (\phi_{m},}\strong{\eqn{\phi_{m}}}\eqn{,\sigma_{m})}.}
}
\value{
Returns "distance" between \code{regime_pars1} and \code{regime_pars2}. Values are scaled
  before calculating the "distance". Read the source code for more details.
}
\description{
\code{regime_distance} calculates "distance" between two scaled regimes.
}
\section{Warning}{

 No argument checks!
}

\references{
\itemize{
   \item Kheifets I.L., Saikkonen P.J. 2020. Stationarity and ergodicity of Vector STAR models.
     \emph{Econometric Reviews}, \strong{39}:4, 407-414.
   \item Lütkepohl H. 2005. New Introduction to Multiple Time Series Analysis, \emph{Springer}.
   \item Lanne M., Virolainen S. 2025. A Gaussian smooth transition vector autoregressive model:
      An application to the macroeconomic effects of severe weather shocks. Unpublished working
      paper, available as arXiv:2403.14216.
   \item Virolainen S. 2025. Identification by non-Gaussianity in structural
      smooth transition vector autoregressive models. Unpublished working
      paper, available as arXiv:2404.19707.
 }
 @keywords internal
}
\keyword{internal}
