% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{proto_hline0}
\alias{proto_hline0}
\alias{proto_hline}
\alias{proto_vline0}
\alias{proto_vline}
\title{Tour proto adding a vertical/horizontal line}
\usage{
proto_hline0(identity_args = list(color = "grey80", size = 0.5, alpha = 0.9))

proto_vline0(identity_args = list(color = "grey80", size = 0.5, alpha = 0.9))
}
\arguments{
\item{identity_args}{A list of static, identity arguments passed into
the primary geom. For instance,
\code{geom_point(size = 2, alpha = .7)} becomes
\code{identity_args = list(size = 2, alpha = .7)}.
Also passes more foundational arguments such as stat and position, though
these have been tested less.}
}
\description{
Adds a vertical/horizontal line with an intercept of 0, scaled to the data
frame.
}
\examples{
library(spinifex)
dat  <- scale_sd(penguins_na.rm[, 1:4])
clas <- penguins_na.rm$species

## 2D case:
gt_path <- save_history(dat, grand_tour(), max_bases = 5)
ggt <- ggtour(gt_path, dat, angle = .1) +
  proto_point(list(color = clas, shape = clas)) +
  proto_hline0() + ## horizonatal line at 0
  proto_vline0()   ## vertical line at 0
\donttest{
animate_plotly(ggt)
}
}
\seealso{
Other ggtour proto functions: 
\code{\link{append_fixed_y}()},
\code{\link{facet_wrap_tour}()},
\code{\link{ggtour}()},
\code{\link{proto_basis}()},
\code{\link{proto_default}()},
\code{\link{proto_density}()},
\code{\link{proto_density2d}()},
\code{\link{proto_hex}()},
\code{\link{proto_highlight}()},
\code{\link{proto_origin}()},
\code{\link{proto_point}()},
\code{\link{proto_text}()},
\code{\link{proto_text_repel}()}
}
\concept{ggtour proto functions}
