% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_variogram_indic.R
\name{extract_variogram}
\alias{extract_variogram}
\title{extract_variogram() method for variogram_sews objects}
\usage{
extract_variogram(x, ...)
}
\arguments{
\item{x}{An object produced by \code{variogram_sews}, or
\code{indictest}}

\item{...}{Additional arguments (ignored)}
}
\value{
A data.frame containing the variogram with the distances 
  (column \code{dist}), the empirical semivariance values (\code{gamma}), 
  and if object contains more than one matrix, a column named \code{matrixn}.
}
\description{
Extract the empirical variogram from a \code{variogram_sews} 
  object
}
\examples{

\donttest{ 
vario_indics <- variogram_sews(serengeti)
predict(vario_indics)
vario_test <- indictest(vario_indics, nulln = 19)
predict(vario_test) # same result
}

}
\seealso{
\code{\link{variogram_sews}}
}
