% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_predictions.R
\name{get_predictions}
\alias{get_predictions}
\title{Gets model predictions}
\usage{
get_predictions(model)
}
\arguments{
\item{model}{A model produced by \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.}
}
\value{
A vector with predictions, or median of the predictions across repetitions if the model was fitted with \code{\link[=rf_repeat]{rf_repeat()}}.
}
\description{
Returns model predictions from a model fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.
}
\examples{
if(interactive()){

#loading example data
data(plant_richness_df)

#fitting a random forest model
rf.model <- rf(
  data = plant_richness_df,
  dependent.variable.name = "richness_species_vascular",
  predictor.variable.names = colnames(plant_richness_df)[5:21],
  n.cores = 1,
  verbose = FALSE
)

#get vector of predictions
x <- get_predictions(rf.model)
x

}
}
