% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_spareg_data}
\alias{simulate_spareg_data}
\title{Simulate Sparse Regression Data}
\usage{
simulate_spareg_data(
  n,
  p,
  ntest,
  a = min(100, p/4),
  snr = 10,
  rho = 0.5,
  mu = 1,
  beta_vals = NULL,
  seed = NULL
)
}
\arguments{
\item{n}{Integer. Number of training samples.}

\item{p}{Integer. Number of predictors (features).}

\item{ntest}{Integer. Number of test samples.}

\item{a}{Integer. Number of non-zero coefficients in the true beta vector. Default is min(100, p/4).}

\item{snr}{Numeric. Signal-to-noise ratio. Default is 10.}

\item{rho}{Numeric between 0 and 1. Pairwise correlation coefficient among predictors.
Default is 0.5. A compound symmetry correlation matrix is used. The variance of
the predictors is fixed to 1.}

\item{mu}{Numeric. Intercept term (mean of response). Default is 1.}

\item{beta_vals}{Numeric. Possible values for non-zero coefficients in the true beta vector.
Default to NULL, in which case the values -3, -2, -1, 1, 2, 3 will be used.}

\item{seed}{Integer. Random seed for reproducibility. Default is NULL.}
}
\value{
A list with the following components:
\describe{
\item{x}{Training design matrix (n x p).}
\item{y}{Training response vector (length n).}
\item{xtest}{Test design matrix (ntest x p).}
\item{ytest}{Test response vector (length ntest).}
\item{mu}{Intercept used in data generation.}
\item{beta}{True coefficient vector (length p).}
\item{sigma2}{Noise variance used in data generation. Equals beta' Sigma beta / snr.}
}
}
\description{
Generates synthetic data for sparse linear regression problems.
Returns training and test sets along with model parameters.
}
\examples{
set.seed(123)
data <- simulate_spareg_data(n = 200, p = 2000, ntest = 100)
str(data)

}
