% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_model.R
\name{run_model}
\alias{run_model}
\title{Fit one of the available Stan models to simulated datasets}
\usage{
run_model(sim, model = NULL, iter = 2000, seed = 1234, cores = 1)
}
\arguments{
\item{sim}{Output from \code{simulate_data()}.}

\item{model}{Name of the Stan model to use (choose from available options).}

\item{iter}{Number of iterations per chain (default = 1000).}

\item{seed}{Random seed for reproducibility.}

\item{cores}{Number of CPU cores (used if cmdstanr or rstan is available).}
}
\value{
A list of fitted model summaries, one per dataset.
}
\description{
Fit one of the available Stan models to simulated datasets
}
\examples{
\donttest{
if (requireNamespace("cmdstanr", quietly = TRUE) ||
    requireNamespace("rstan", quietly = TRUE)) {
  sim <- simulate_data(ind = 100, Valpha = 0.2, Vepsilon = 0.1, iterations = 2)
  res <- run_model(sim, model = "Trait.stan", iter = 500, cores = 2)
  summary(res)
} else {
  message("CmdStanR or rstan not available; example skipped.")
}
}
}
