% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.pls.R
\name{format.pls}
\alias{format.pls}
\title{Format PLS Model Output as LaTeX or Console Tables}
\usage{
\method{format}{pls}(x, ..., include.scores = TRUE, latex = FALSE)
}
\arguments{
\item{x}{A list returned by \code{\link{pls.regression}()} (class \code{"pls"}) containing PLS model components.}

\item{...}{Further arguments passed to or from methods (unused).}

\item{include.scores}{Logical. Whether to include score matrices (T and U). Default is \code{TRUE}.}

\item{latex}{Logical. If \code{TRUE}, produces LaTeX output (for PDF rendering). If \code{FALSE}, prints to console. Default is \code{FALSE}.}
}
\value{
When \code{latex = TRUE}, returns a \code{knitr::asis_output} object (LaTeX code). When \code{FALSE}, prints formatted tables to console.
}
\description{
Formats and displays Partial Least Squares (PLS) model output from \code{pls.regression()}
as either LaTeX tables (for PDF rendering) or console-friendly output.
}
