% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nlsy97}
\alias{nlsy97}
\title{NLSY97 Substance Use Data}
\format{
A data frame with 1004 rows and 38 columns:
\describe{
\item{\code{SEX}}{Respondent's sex}
\item{\code{RACE}}{Respondent's race}
\item{\code{ESMK_98}, \code{ESMK_03}, \code{ESMK_08}}{(Ever smoked) Ever smoked in 1998, 2003, and 2008 (0: No, 1: Yes)}
\item{\code{FSMK_98}, \code{FSMK_03}, \code{FSMK_08}}{(Frequent smoke) Monthly smoking in 1998, 2003, and 2008 (0: No, 1: Yes)}
\item{\code{DSMK_98}, \code{DSMK_03}, \code{DSMK_08}}{(Daily smoke) Daily smoking in 1998, 2003, and 2008 (0: No, 1: Yes)}
\item{\code{HSMK_98}, \code{HSMK_03}, \code{HSMK_08}}{(Heavy smoke) 10+ cigarettes per day in 1998, 2003, and 2008 (0: No, 1: Yes)}
\item{\code{EDRK_98}, \code{EDRK_03}, \code{EDRK_08}}{(Ever drunk) Ever drunk in 1998, 2003, and 2008? (0: No, 1: Yes)}
\item{\code{CDRK_98}, \code{CDRK_03}, \code{CDRK_08}}{(Current drinker) Monthly drinking in 1998, 2003, and 2008 (0: No, 1: Yes)}
\item{\code{WDRK_98}, \code{WDRK_03}, \code{WDRK_08}}{(Weakly drinker) 5+ days drinking in a month in 1998, 2003, and 2008 (0: No, 1: Yes)}
\item{\code{BDRK_98}, \code{BDRK_03}, \code{BDRK_08}}{(Binge drinker) 5+ drinks on the same day at least one time in the last 30 day (0: No, 1: Yes)}
\item{\code{EMRJ_98}, \code{EMRJ_03}, \code{EMRJ_08}}{(Ever marijuana used) Have you ever used marijuana in 1998, 2003, and 2008? (0: No, 1: Yes)}
\item{\code{CMRJ_98}, \code{CMRJ_03}, \code{CMRJ_08}}{(Current marijuana user) Monthly marijuana use in 1998, 2003, and 2008 (0: No, 1: Yes)}
\item{\code{OMRJ_98}, \code{OMRJ_03}, \code{OMRJ_08}}{(Occasional marijuana user) 10+ days marijuana use in a month in 1998, 2003, and 2008 (0: No, 1: Yes)}
\item{\code{SMRJ_98}, \code{SMRJ_03}, \code{SMRJ_08}}{(School/work marijuana user) Marijuana use before/during school or work in 1998, 2003, and 2008 (0: No, 1: Yes)}
}
}
\source{
National Longitudinal Survey of Youth 1997 (NLSY97)
}
\usage{
nlsy97
}
\description{
This dataset contains substance use behavior data from the National Longitudinal Survey of Youth 1997 (NLSY97) for three years: 1998, 2003, and 2008.
The dataset focuses on youth born in 1984 and tracks three types of substance use behaviors: tobacco/cigarette smoking, alcohol drinking, and marijuana use.
}
\examples{
library(magrittr)
nlsy_smoke <- slca(SMK_98(3) ~ ESMK_98 + FSMK_98 + DSMK_98 + HSMK_98) \%>\%
   estimate(data = nlsy97, control = list(verbose = FALSE))
summary(nlsy_smoke)

\donttest{
# JLCA
model_jlca <- slca(
   SMK_98(3) ~ ESMK_98 + FSMK_98 + DSMK_98 + HSMK_98,
   DRK_98(3) ~ EDRK_98 + CDRK_98 + WDRK_98 + BDRK_98,
   MRJ_98(3) ~ EMRJ_98 + CMRJ_98 + OMRJ_98 + SMRJ_98,
   SUB_98(4) ~ SMK_98 + DRK_98 + MRJ_98
) \%>\% estimate(data = nlsy97, control = list(verbose = FALSE))
summary(model_jlca)
param(model_jlca)

# JLCPA
nlsy_jlcpa <- slca(
   SMK_98(3) ~ ESMK_98 + FSMK_98 + DSMK_98 + HSMK_98,
   DRK_98(3) ~ EDRK_98 + CDRK_98 + WDRK_98 + BDRK_98,
   MRJ_98(3) ~ EMRJ_98 + CMRJ_98 + OMRJ_98 + SMRJ_98,
   SUB_98(5) ~ SMK_98 + DRK_98 + MRJ_98,
   SMK_03(3) ~ ESMK_03 + FSMK_03 + DSMK_03 + HSMK_03,
   DRK_03(3) ~ EDRK_03 + CDRK_03 + WDRK_03 + BDRK_03,
   MRJ_03(3) ~ EMRJ_03 + CMRJ_03 + OMRJ_03 + SMRJ_03,
   SUB_03(5) ~ SMK_03 + DRK_03 + MRJ_03,
   SMK_08(3) ~ ESMK_08 + FSMK_08 + DSMK_08 + HSMK_08,
   DRK_08(3) ~ EDRK_08 + CDRK_08 + WDRK_08 + BDRK_08,
   MRJ_08(3) ~ EMRJ_08 + CMRJ_08 + OMRJ_08 + SMRJ_08,
   SUB_08(5) ~ SMK_08 + DRK_08 + MRJ_08,
   PROF(4) ~ SUB_98 + SUB_03 + SUB_08,
   constraints = list(
      c("SMK_98", "SMK_03", "SMK_08"),
      c("DRK_98", "DRK_03", "DRK_08"),
      c("MRJ_98", "MRJ_03", "MRJ_08"),
      c("SUB_98 ~ SMK_98", "SUB_03 ~ SMK_03", "SUB_08 ~ SMK_08"),
      c("SUB_98 ~ DRK_98", "SUB_03 ~ DRK_03", "SUB_08 ~ DRK_08"),
      c("SUB_98 ~ MRJ_98", "SUB_03 ~ MRJ_03", "SUB_08 ~ MRJ_08")
   )
) \%>\% estimate(nlsy97, control = list(verbose = FALSE))
}
}
\references{
Bureau of Labor Statistics, U.S. Department of Labor. National Longitudinal Survey of Youth 1997 cohort, 1997-2017 (rounds 1-18). Produced and distributed by the Center for Human Resource Research (CHRR), The Ohio State University. Columbus, OH: 2019.
}
\keyword{datasets}
