% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stk_mask.R
\name{stk_mask}
\alias{stk_mask}
\title{Generate a land surface mask}
\usage{
stk_mask(buffer = 0, resolution = 1, bbox, sf = FALSE)
}
\arguments{
\item{buffer}{The buffer distance from land areas (in km, default = 0
excluding all water bodies).}

\item{resolution}{The resolution of the spatial grid in degrees, when exporting
as a terra SpatRaster (default = 1).}

\item{bbox}{A bounding box of the mask to constrain the estimated location
parameter space.}

\item{sf}{Return the land mask as an 'sf' polygon, not a rasterized map for.
use in map plotting, not used for processing (default = FALSE)}
}
\value{
A buffered land mask as an 'sf' or 'terra' map object.
}
\description{
Returns a (buffered) land mask to constrain potential
model results.
}
\examples{
\donttest{
# define land mask with a bounding box
# and an off-shore buffer (in km), in addition
# you can specifiy the resolution of the resulting raster
mask <- stk_mask(
  bbox  =  c(-20, -40, 60, 60), #xmin, ymin, xmax, ymax
  buffer = 150, # in km
  resolution = 0.5 # map grid in degrees
  )
 }
}
