% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{controlModel}
\alias{controlModel}
\title{Control parameters specific to some models}
\usage{
controlModel(
  weightsAsCounts = FALSE,
  omegaFormula = ~1,
  alphaFormula = ~1,
  piFormula = ~1
)
}
\arguments{
\item{weightsAsCounts}{a boolean value indicating whether to treat \code{weights}
argument as number of occurrences for each row in the \code{data} and adjust
necessary methods and functionalities, like adjustments in bootstrap or
decreasing weights in \code{dfbeta} instead or deleting rows from data,
to accommodate this form of model specification.}

\item{omegaFormula}{a formula for inflation parameter in one inflated zero
truncated and zero truncated one inflated models.}

\item{alphaFormula}{a formula for dispersion parameter in negative binomial
based models.}

\item{piFormula}{a formula for probability parameter in pseudo hurdle zero
truncated and zero truncated pseudo hurdle models.}
}
\value{
A list with selected parameters, it is also possible to call list directly.
}
\description{
\code{controlModel} constructs a list with all necessary
control parameters in \code{estimatePopsize} that are either specific to
selected model or do not fit anywhere else.

Specifying additional formulas should be done by using only right hand side of
the formula also for now all variables from additional formulas should also be
included in the "main" formula.
}
\seealso{
\code{\link[=estimatePopsize]{estimatePopsize()}} \code{\link[=controlMethod]{controlMethod()}} \code{\link[=controlPopVar]{controlPopVar()}} \code{\link[=singleRmodels]{singleRmodels()}}
}
\author{
Piotr Chlebicki, Maciej Beręsewicz
}
