% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resampling.R
\name{Folds}
\alias{Folds}
\title{Splitting observations into folds}
\usage{
Folds(data, family = NULL, n_folds = 5)
}
\arguments{
\item{data}{vector or matrix of data. In regression, this should be the
outcome data.}

\item{family}{type of regression model. This argument is defined as in
\code{\link[glmnet]{glmnet}}. Possible values include \code{"gaussian"}
(linear regression), \code{"binomial"} (logistic regression),
\code{"multinomial"} (multinomial regression), and \code{"cox"} (survival
analysis).}

\item{n_folds}{number of folds.}
}
\value{
A list of length \code{n_folds} with sets of non-overlapping
  observation IDs.
}
\description{
Generates a list of \code{n_folds} non-overlapping sets of observation IDs
(folds).
}
\details{
For categorical outcomes (i.e. \code{family} argument is set to
  \code{"binomial"}, \code{"multinomial"} or \code{"cox"}), the split is done
  such that the proportion of observations from each of the categories in
  each of the folds is representative of that of the full sample.
}
\examples{
# Splitting into 5 folds
simul <- SimulateRegression()
ids <- Folds(data = simul$ydata)
lapply(ids, length)

# Balanced folds with respect to a binary variable
simul <- SimulateRegression(family = "binomial")
ids <- Folds(data = simul$ydata, family = "binomial")
lapply(ids, FUN = function(x) {
  table(simul$ydata[x, ])
})
}
