% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/LIGER_Utilities.R,
%   R/QC_Utilities_Seurat.R
\name{Add_Hemo}
\alias{Add_Hemo}
\alias{Add_Hemo.liger}
\alias{Add_Hemo.Seurat}
\title{Add Hemoglobin percentages}
\usage{
Add_Hemo(object, ...)

\method{Add_Hemo}{liger}(
  object,
  species,
  hemo_name = "percent_hemo",
  hemo_pattern = NULL,
  hemo_features = NULL,
  ensembl_ids = FALSE,
  overwrite = FALSE,
  list_species_names = FALSE,
  ...
)

\method{Add_Hemo}{Seurat}(
  object,
  species,
  hemo_name = "percent_hemo",
  hemo_pattern = NULL,
  hemo_features = NULL,
  ensembl_ids = FALSE,
  assay = NULL,
  overwrite = FALSE,
  list_species_names = FALSE,
  ...
)
}
\arguments{
\item{object}{Seurat or LIGER object}

\item{...}{Arguments passed to other methods}

\item{species}{Species of origin for given Seurat Object.  If mouse, human, marmoset, zebrafish, rat,
drosophila, rhesus macaque, or chicken (name or abbreviation) are provided the function will automatically
generate hemo_pattern values.}

\item{hemo_name}{name to use for the new meta.data column containing percent hemoglobin counts.
Default is "percent_hemo".}

\item{hemo_pattern}{A regex pattern to match features against for hemoglobin genes (will set automatically if
species is mouse or human; marmoset features list saved separately).}

\item{hemo_features}{A list of hemoglobin gene names to be used instead of using regex pattern.}

\item{ensembl_ids}{logical, whether feature names in the object are gene names or
ensembl IDs (default is FALSE; set TRUE if feature names are ensembl IDs).}

\item{overwrite}{Logical.  Whether to overwrite existing meta.data columns.  Default is FALSE meaning that
function will abort if columns with any one of the names provided to \code{hemo_name} is
present in meta.data slot.}

\item{list_species_names}{returns list of all accepted values to use for default species names which
contain internal regex/feature lists (human, mouse, marmoset, zebrafish, rat, drosophila, and
rhesus macaque).  Default is FALSE.}

\item{assay}{Assay to use (default is the current object default assay).}
}
\value{
An object of the same class as \code{object} with columns added to object meta data.
}
\description{
Add hemoglobin percentages to meta.data slot of Seurat Object or
cell.data/cellMeta slot of Liger object
}
\examples{
\dontrun{
# Liger
liger_object <- Add_Hemo(object = liger_object, species = "human")
}

\dontrun{
# Seurat
seurat_object <- Add_Hemo(object = seurat_object, species = "human")
}

}
\concept{qc_util}
