% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-sim_sample.R
\name{sim_sample}
\alias{sim_sample}
\title{Sampling component}
\usage{
sim_sample(simSetup, smplFun = sample_number(size = 5L, groupVars = "idD"))
}
\arguments{
\item{simSetup}{a \code{sim_setup}.}

\item{smplFun}{function which controls the sampling process.}
}
\description{
One of the components which can be added to a \code{sim_setup}. This component can be used to add a sampling mechanism to the simulation set-up. A sample will be drawn after the population is generated (\code{\link{sim_gen}}) and variables on the population are computed (\code{\link{sim_comp_pop}}).
}
\details{
Potentially you can define a \code{smplFun} yourself. Take care that it has one argument, named \code{dat} being the data as data.frame, and returns the sample as data.frame.
}
\examples{
# Simple random sample - 5\% sample:
sim_base_lm() \%>\% sim_sample(sample_fraction(0.05))

# Simple random sampling proportional to size - 5\% in each domain:
sim_base_lm() \%>\% sim_sample(sample_fraction(0.05, groupVars = "idD"))

# User defined sampling function:
sample_mySampleFun <- function(dat) {
  dat[sample.int(nrow(dat), 10), ]
}

sim_base_lm() \%>\% sim_sample(sample_mySampleFun)
}
\seealso{
\code{\link{sample_number}}, \code{\link{sample_fraction}}
}
