% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R, R/generics.R, R/liger-methods.R,
%   R/ligerDataset-methods.R
\docType{class}
\name{liger-class}
\alias{liger-class}
\alias{liger}
\alias{datasets}
\alias{datasets<-}
\alias{dataset}
\alias{dataset<-}
\alias{cellMeta}
\alias{cellMeta<-}
\alias{defaultCluster}
\alias{defaultCluster<-}
\alias{dimReds}
\alias{dimReds<-}
\alias{dimRed}
\alias{dimRed<-}
\alias{defaultDimRed}
\alias{defaultDimRed<-}
\alias{varFeatures}
\alias{varFeatures<-}
\alias{varUnsharedFeatures}
\alias{varUnsharedFeatures<-}
\alias{commands}
\alias{show,liger-method}
\alias{dim,liger-method}
\alias{dimnames,liger-method}
\alias{dimnames<-,liger,list-method}
\alias{datasets,liger-method}
\alias{datasets<-,liger,logical-method}
\alias{datasets<-,liger,missing-method}
\alias{dataset,liger,character_OR_NULL-method}
\alias{dataset,liger,missing-method}
\alias{dataset,liger,numeric-method}
\alias{dataset<-,liger,character,missing,ANY,ligerDataset-method}
\alias{dataset<-,liger,character,ANY,ANY,matrixLike-method}
\alias{dataset<-,liger,character,missing,ANY,NULL-method}
\alias{names.liger}
\alias{names<-.liger}
\alias{length.liger}
\alias{lengths.liger}
\alias{cellMeta,liger,NULL-method}
\alias{cellMeta,liger,character-method}
\alias{cellMeta,liger,missing-method}
\alias{cellMeta<-,liger,missing-method}
\alias{cellMeta<-,liger,character-method}
\alias{rawData,liger-method}
\alias{rawData<-,liger,ANY,ANY,matrixLike_OR_NULL-method}
\alias{rawData<-,liger,ANY,ANY,H5D-method}
\alias{normData,liger-method}
\alias{normData<-,liger,ANY,ANY,matrixLike_OR_NULL-method}
\alias{normData<-,liger,ANY,ANY,H5D-method}
\alias{scaleData,liger,ANY-method}
\alias{scaleData<-,liger,ANY,ANY,matrixLike_OR_NULL-method}
\alias{scaleData<-,liger,ANY,ANY,H5D-method}
\alias{scaleData<-,liger,ANY,ANY,H5Group-method}
\alias{scaleUnsharedData,liger,character-method}
\alias{scaleUnsharedData,liger,numeric-method}
\alias{scaleUnsharedData<-,liger,ANY,ANY,matrixLike_OR_NULL-method}
\alias{scaleUnsharedData<-,liger,ANY,ANY,H5D-method}
\alias{scaleUnsharedData<-,liger,ANY,ANY,H5Group-method}
\alias{getMatrix,liger,ANY,ANY,ANY-method}
\alias{getH5File,liger,ANY-method}
\alias{[[<-.liger}
\alias{$.liger}
\alias{$<-.liger}
\alias{defaultCluster,liger-method}
\alias{defaultCluster<-,liger,ANY,ANY,character-method}
\alias{defaultCluster<-,liger,ANY,ANY,factor-method}
\alias{defaultCluster<-,liger,ANY,ANY,NULL-method}
\alias{dimReds,liger-method}
\alias{dimReds<-,liger,list-method}
\alias{dimRed,liger,missing_OR_NULL-method}
\alias{dimRed,liger,index-method}
\alias{dimRed<-,liger,index,ANY,ANY,NULL-method}
\alias{dimRed<-,liger,character,ANY,ANY,matrixLike-method}
\alias{defaultDimRed,liger-method}
\alias{defaultDimRed<-,liger,character-method}
\alias{varFeatures,liger-method}
\alias{varFeatures<-,liger,ANY,character-method}
\alias{varUnsharedFeatures,liger,ANY-method}
\alias{varUnsharedFeatures<-,liger,ANY,ANY,character-method}
\alias{fortify.liger}
\alias{c.liger}
\alias{commands,liger-method}
\alias{varUnsharedFeatures,ligerDataset,missing-method}
\alias{varUnsharedFeatures<-,ligerDataset,missing,ANY,character-method}
\title{liger class}
\usage{
datasets(x, check = NULL)

datasets(x, check = TRUE) <- value

dataset(x, dataset = NULL)

dataset(x, dataset, type = NULL, qc = TRUE) <- value

cellMeta(
  x,
  columns = NULL,
  useDatasets = NULL,
  cellIdx = NULL,
  as.data.frame = FALSE,
  ...
)

cellMeta(
  x,
  columns = NULL,
  useDatasets = NULL,
  cellIdx = NULL,
  inplace = FALSE,
  check = FALSE
) <- value

defaultCluster(x, useDatasets = NULL, ...)

defaultCluster(x, name = NULL, useDatasets = NULL, ...) <- value

dimReds(x)

dimReds(x) <- value

dimRed(x, name = NULL, useDatasets = NULL, cellIdx = NULL, ...)

dimRed(x, name = NULL, useDatasets = NULL, cellIdx = NULL, ...) <- value

defaultDimRed(x, useDatasets = NULL, cellIdx = NULL)

defaultDimRed(x) <- value

varFeatures(x)

varFeatures(x, check = TRUE) <- value

varUnsharedFeatures(x, dataset = NULL)

varUnsharedFeatures(x, dataset, check = TRUE) <- value

commands(x, funcName = NULL, arg = NULL)

\S4method{show}{liger}(object)

\S4method{dim}{liger}(x)

\S4method{dimnames}{liger}(x)

\S4method{dimnames}{liger,list}(x) <- value

\S4method{datasets}{liger}(x, check = NULL)

\S4method{datasets}{liger,logical}(x, check = TRUE) <- value

\S4method{datasets}{liger,missing}(x, check = TRUE) <- value

\S4method{dataset}{liger,character_OR_NULL}(x, dataset = NULL)

\S4method{dataset}{liger,missing}(x, dataset = NULL)

\S4method{dataset}{liger,numeric}(x, dataset = NULL)

\S4method{dataset}{liger,character,missing,ANY,ligerDataset}(x, dataset, type = NULL, qc = TRUE) <- value

\S4method{dataset}{liger,character,ANY,ANY,matrixLike}(x, dataset, type = c("rawData", "normData"), qc = FALSE) <- value

\S4method{dataset}{liger,character,missing,ANY,NULL}(x, dataset, type = NULL, qc = TRUE) <- value

\method{names}{liger}(x)

\method{names}{liger}(x) <- value

\method{length}{liger}(x)

\method{lengths}{liger}(x, use.names = TRUE)

\S4method{cellMeta}{liger,NULL}(
  x,
  columns = NULL,
  useDatasets = NULL,
  cellIdx = NULL,
  as.data.frame = FALSE,
  ...
)

\S4method{cellMeta}{liger,character}(
  x,
  columns = NULL,
  useDatasets = NULL,
  cellIdx = NULL,
  as.data.frame = FALSE,
  ...
)

\S4method{cellMeta}{liger,missing}(
  x,
  columns = NULL,
  useDatasets = NULL,
  cellIdx = NULL,
  as.data.frame = FALSE,
  ...
)

\S4method{cellMeta}{liger,missing}(x, columns = NULL, useDatasets = NULL, cellIdx = NULL, check = FALSE) <- value

\S4method{cellMeta}{liger,character}(
  x,
  columns = NULL,
  useDatasets = NULL,
  cellIdx = NULL,
  inplace = TRUE,
  check = FALSE
) <- value

\S4method{rawData}{liger}(x, dataset = NULL)

\S4method{rawData}{liger,ANY,ANY,matrixLike_OR_NULL}(x, dataset = NULL, check = TRUE) <- value

\S4method{rawData}{liger,ANY,ANY,H5D}(x, dataset = NULL, check = TRUE) <- value

\S4method{normData}{liger}(x, dataset = NULL)

\S4method{normData}{liger,ANY,ANY,matrixLike_OR_NULL}(x, dataset = NULL, check = TRUE) <- value

\S4method{normData}{liger,ANY,ANY,H5D}(x, dataset = NULL, check = TRUE) <- value

\S4method{scaleData}{liger,ANY}(x, dataset = NULL)

\S4method{scaleData}{liger,ANY,ANY,matrixLike_OR_NULL}(x, dataset = NULL, check = TRUE) <- value

\S4method{scaleData}{liger,ANY,ANY,H5D}(x, dataset = NULL, check = TRUE) <- value

\S4method{scaleData}{liger,ANY,ANY,H5Group}(x, dataset = NULL, check = TRUE) <- value

\S4method{scaleUnsharedData}{liger,character}(x, dataset = NULL)

\S4method{scaleUnsharedData}{liger,numeric}(x, dataset = NULL)

\S4method{scaleUnsharedData}{liger,ANY,ANY,matrixLike_OR_NULL}(x, dataset = NULL, check = TRUE) <- value

\S4method{scaleUnsharedData}{liger,ANY,ANY,H5D}(x, dataset = NULL, check = TRUE) <- value

\S4method{scaleUnsharedData}{liger,ANY,ANY,H5Group}(x, dataset = NULL, check = TRUE) <- value

\S4method{getMatrix}{liger,ANY,ANY,ANY}(
  x,
  slot = c("rawData", "normData", "scaleData", "scaleUnsharedData", "H", "V", "U", "A",
    "B", "W", "H.norm", "rawPeak", "normPeak"),
  dataset = NULL,
  returnList = FALSE
)

\S4method{getH5File}{liger,ANY}(x, dataset = NULL)

\method{[[}{liger}(x, i) <- value

\method{$}{liger}(x, name)

\method{$}{liger}(x, name) <- value

\S4method{defaultCluster}{liger}(x, useDatasets = NULL, droplevels = FALSE, ...)

\S4method{defaultCluster}{liger,ANY,ANY,character}(x, name = NULL, useDatasets = NULL, ...) <- value

\S4method{defaultCluster}{liger,ANY,ANY,factor}(x, name = NULL, useDatasets = NULL, droplevels = TRUE, ...) <- value

\S4method{defaultCluster}{liger,ANY,ANY,NULL}(x, name = NULL, useDatasets = NULL, ...) <- value

\S4method{dimReds}{liger}(x)

\S4method{dimReds}{liger,list}(x) <- value

\S4method{dimRed}{liger,missing_OR_NULL}(x, name = NULL, useDatasets = NULL, cellIdx = NULL, ...)

\S4method{dimRed}{liger,index}(x, name = NULL, useDatasets = NULL, cellIdx = NULL, ...)

\S4method{dimRed}{liger,index,ANY,ANY,NULL}(x, name = NULL, useDatasets = NULL, cellIdx = NULL, ...) <- value

\S4method{dimRed}{liger,character,ANY,ANY,matrixLike}(
  x,
  name = NULL,
  useDatasets = NULL,
  cellIdx = NULL,
  asDefault = NULL,
  inplace = FALSE,
  ...
) <- value

\S4method{defaultDimRed}{liger}(x, useDatasets = NULL, cellIdx = NULL)

\S4method{defaultDimRed}{liger,character}(x) <- value

\S4method{varFeatures}{liger}(x)

\S4method{varFeatures}{liger,ANY,character}(x, check = TRUE) <- value

\S4method{varUnsharedFeatures}{liger,ANY}(x, dataset = NULL)

\S4method{varUnsharedFeatures}{liger,ANY,ANY,character}(x, dataset, check = TRUE) <- value

\method{fortify}{liger}(model, data, ...)

\method{c}{liger}(...)

\S4method{commands}{liger}(x, funcName = NULL, arg = NULL)

\S4method{varUnsharedFeatures}{ligerDataset,missing}(x, dataset = NULL)

\S4method{varUnsharedFeatures}{ligerDataset,missing,ANY,character}(x, dataset = NULL, check = TRUE) <- value
}
\arguments{
\item{x, object, model}{A \linkS4class{liger} object}

\item{check}{Logical, whether to perform object validity check on setting new
value. Users are not supposed to set \code{FALSE} here.}

\item{value}{Metadata value to be inserted}

\item{dataset}{Name or numeric index of a dataset}

\item{type}{When using \code{dataset<-} with a matrix like \code{value},
specify what type the matrix is. Choose from \code{"rawData"},
\code{"normData"} or \code{"scaleData"}.}

\item{qc}{Logical, whether to perform general qc on added new dataset.}

\item{columns}{The names of available variables in \code{cellMeta} slot. When
\code{as.data.frame = TRUE}, please use variable names after coercion.}

\item{useDatasets}{Setter or getter method should only apply on cells in
specified datasets. Any valid character, numeric or logical subscriber is
acceptable. Default \code{NULL} works with all datasets.}

\item{cellIdx}{Valid cell subscription to subset retrieved variables. Default
\code{NULL} uses all cells.}

\item{as.data.frame}{Logical, whether to apply
\code{\link[base]{as.data.frame}} on the subscription. Default \code{FALSE}.}

\item{...}{See detailed sections for explanation.}

\item{inplace}{For \code{cellMeta<-} method, when \code{columns} is for
existing variable and \code{useDatasets} or \code{cellIdx} indicate partial
insertion to the object, whether to by default (\code{TRUE}) in-place insert
\code{value} into the variable for selected cells or to replace the whole
variable with non-selected part left as NA.}

\item{name}{The name of available variables in \code{cellMeta} slot or the
name of a new variable to store.}

\item{funcName, arg}{See Command records section.}

\item{use.names}{Whether returned vector should be named with dataset names.}

\item{slot}{Name of slot to retrieve matrix from. Options shown in Usage.}

\item{returnList}{Logical, whether to force return a list even when only one
dataset-specific matrix (i.e. expression matrices, H, V or U) is requested.
Default \code{FALSE}.}

\item{i}{Name or numeric index of cell meta variable to be replaced}

\item{droplevels}{Whether to remove unused cluster levels from the factor
object fetched by \code{defaultCluster()}. Default \code{FALSE}.}

\item{asDefault}{Whether to set the inserted dimension reduction matrix as
default for visualization methods. Default \code{NULL} sets it when no
default has been set yet, otherwise does not change current default.}

\item{data}{fortify method required argument. Not used.}
}
\value{
See detailed sections for explanetion.

Input liger object updated with replaced/new variable in
\code{cellMeta(x)}.
}
\description{
\code{liger} object is the main data container for LIGER
analysis in R. The slot \code{datasets} is a list where each element should
be a \linkS4class{ligerDataset} object containing dataset specific
information, such as the expression matrices. The other parts of liger object
stores information that can be shared across the analysis, such as the cell
metadata.

This manual provides explanation to the \code{liger} object structure as well
as usage of class-specific methods. Please see detail sections for more
information.

For \code{liger} objects created with older versions of rliger package,
please try updating the objects individually with
\code{\link{convertOldLiger}}.
}
\section{Slots}{

\describe{
\item{\code{datasets}}{list of \linkS4class{ligerDataset} objects. Use generic
\code{dataset}, \code{dataset<-}, \code{datasets} or \code{datasets<-} to
interact with. See detailed section accordingly.}

\item{\code{cellMeta}}{\link[S4Vectors]{DFrame} object for cell metadata. Pre-existing
metadata, QC metrics, cluster labeling and etc. are all stored here. Use
generic \code{cellMeta}, \code{cellMeta<-}, \code{$}, \code{[[]]} or
\code{[[]]<-} to interact with. See detailed section accordingly.}

\item{\code{varFeatures}}{Character vector of names of variable features. Use generic
\code{varFeatures} or \code{varFeatures<-} to interact with. See detailed
section accordingly.}

\item{\code{W}}{iNMF output matrix of shared gene loadings for each factor. See
\code{\link{runIntegration}}.}

\item{\code{H.norm}}{Matrix of aligned factor loading for each cell. See
\code{\link{alignFactors}} and \code{\link{runIntegration}}.}

\item{\code{commands}}{List of \linkS4class{ligerCommand} objects. Record of
analysis. Use \code{commands} to retrieve information. See detailed section
accordingly.}

\item{\code{uns}}{List for unstructured meta-info of analyses or presets.}

\item{\code{version}}{Record of version of rliger package}
}}

\section{Dataset access}{

\code{datasets()} method only accesses the \code{datasets} slot, the list of
\linkS4class{ligerDataset} objects. \code{dataset()} method accesses a single
dataset, with subsequent cell metadata updates and checks bonded when adding
or modifying a dataset. Therefore, when users want to modify something inside
a \code{ligerDataset} while no cell metadata change should happen, it is
recommended to use: \code{datasets(x)[[name]] <- ligerD} for efficiency,
though the result would be the same as \code{dataset(x, name) <- ligerD}.

\code{length()} and \code{names()} methods are implemented to access the
number and names of datasets. \code{names<-} method is supported for
modifying dataset names, with taking care of the "dataset" variable in cell
metadata.
}

\section{Matrix access}{

For \code{liger} object, \code{rawData()}, \code{normData},
\code{scaleData()} and \code{scaleUnsharedData()} methods are exported for
users to access the corresponding feature expression matrix with
specification of one dataset. For retrieving a type of matrix from multiple
datasets, please use \code{getMatrix()} method.

When only one matrix is expected to be retrieved by \code{getMatrix()}, the
matrix itself will be returned. A list will be returned if multiple matrices
is requested (by querying multiple datasets) or \code{returnList} is set to
\code{TRUE}.
}

\section{Cell metadata access}{

Three approaches are provided for access of cell metadata. A generic function
\code{cellMeta} is implemented with plenty of options and multi-variable
accessibility. Besides, users can use double-bracket (e.g.
\code{ligerObj[[varName]]}) or dollor-sign (e.g. \code{ligerObj$nUMI}) to
access or modify single variables.

For users' convenience of generating a customized ggplot with available cell
metadata, the S3 method \code{fortify.liger} is implemented. With this under
the hook, users can create simple ggplots by directly starting with
\code{ggplot(ligerObj, aes(...))} where cell metadata variables can be
directly thrown into \code{aes()}.

Special partial metadata insertion is implemented specifically for mapping
categorical annotation from sub-population (subset object) back to original
experiment (full-size object). For example, when sub-clustering and
annotation is done for a specific cell-type of cells (stored in
\code{subobj}) subset from an experiment (stored as \code{obj}), users can do
\code{cellMeta(obj, "sub_ann", cellIdx = colnames(subobj)) <- subobj$sub_ann}
to map the value back, leaving other cells non-annotated with NAs. Plotting
with this variable will then also show NA cells with default grey color.
Furthermore, sub-clustering labels for other cell types can also be mapped
to the same variable. For example, \code{cellMeta(obj, "sub_ann",
cellIdx = colnames(subobj2)) <- subobj2$sub_ann}. As long as the labeling
variables are stored as factor class (categorical), the levels (category
names) will be properly handled and merged. Other situations follow the R
default behavior (e.g. categories might be converted to integer numbers if
mapped to numerical variable in the original object). Note that this feature
is only available with using the generic function \code{cellMeta} but not
with the \code{`[[`} or \code{`$`} accessing methods due to syntax reasons.

The generic \code{defaultCluster} works as both getter and setter. As a
setter, users can do \code{defaultCluster(obj) <- "existingVariableName"} to
set a categorical variable as default cluster used for visualization or
downstream analysis. Users can also do \code{defaultCluster(obj,
"newVarName") <- factorOfLabels} to push new labeling into the object and set
as default. For getter method, the function returns a factor object of the
default cluster labeling. Argument \code{useDatasets} can be used for
requiring that given or retrieved labeling should match with cells in
specified datasets. We generally don't recommend setting \code{"dataset"} as
a default cluster because it is a preserved (always existing) field in
metadata and can lead to meaningless result when running analysis that
utilizes both clustering information and the dataset source information.
}

\section{Dimension reduction access}{

Currently, low-dimensional representaion of cells, presented as dense
matrices, are all stored in \code{dimReds} slot, and can totally be accessed
with generics \code{dimRed} and \code{dimRed<-}. Adding a dimRed to the
object looks as simple as \code{dimRed(obj, "name") <- matrixLike}. It can
be retrieved back with \code{dimRed(obj, "name")}. Similar to having a
default cluster labeling, we also constructed the feature of default dimRed.
It can be set with \code{defaultDimRed(obj) <- "existingMatLikeVar"} and the
matrix can be retrieved with \code{defaultDimRed(obj)}.
}

\section{Variable feature access}{

The \code{varFeatures} slot allows for character vectors of gene names.
\code{varFeatures(x)} returns this vector and \code{value} for
\code{varFeatures<-} method has to be a character vector or \code{NULL}.
The replacement method, when \code{check = TRUE} performs checks on gene
name consistency check across the \code{scaleData}, \code{H}, \code{V} slots
of inner \code{ligerDataset} objects as well as the \code{W} and
\code{H.norm} slots of the input \code{liger} object.
}

\section{Command records}{

rliger functions, that perform calculation and update the \code{liger}
object, will be recorded in a \code{ligerCommand} object and stored in the
\code{commands} slot, a list, of \code{liger} object. Method
\code{commands()} is implemented to retrieve or show the log history.
Running with \code{funcName = NULL} (default) returns all command labels.
Specifying \code{funcName} allows partial matching to all command labels
and returns a subset list (of \code{ligerCommand} object) of matches (or
the \code{ligerCommand} object if only one match found). If \code{arg} is
further specified, a subset list of parameters from the matches will be
returned. For example, requesting a list of resolution values used in
all louvain cluster attempts: \code{commands(ligerObj, "louvainCluster",
"resolution")}
}

\section{Dimensionality}{

For a \code{liger} object, the column orientation is assigned for
cells. Due to the data structure, it is hard to define a row index for the
\code{liger} object, which might contain datasets that vary in number of
genes.

Therefore, for \code{liger} objects, \code{dim} and \code{dimnames} returns
\code{NA}/\code{NULL} for rows and total cell counts/barcodes for the
columns.

For direct call of \code{dimnames<-} method, \code{value} should be a list
with \code{NULL} as the first element and valid cell identifiers as the
second element. For \code{colnames<-} method, the character vector of cell
identifiers. \code{rownames<-} method is not applicable.
}

\section{Subsetting}{

For more detail of subsetting a \code{liger} object or a
\linkS4class{ligerDataset} object, please check out \code{\link{subsetLiger}}
and \code{\link{subsetLigerDataset}}. Here, we set the S4 method
"single-bracket" \code{[} as a quick wrapper to subset a \code{liger} object.
Note that \code{j} serves as cell subscriptor which can be any valid index
refering the collection of all cells (i.e. \code{rownames(cellMeta(obj))}).
While \code{i}, the feature subscriptor can only be character vector because
the features for each dataset can vary. \code{...} arugments are passed to
\code{subsetLiger} so that advanced options are allowed.
}

\section{Combining multiple liger object}{
 The list of \code{datasets} slot,
the rows of \code{cellMeta} slot and the list of \code{commands} slot will
be simply concatenated. Variable features in \code{varFeatures} slot will be
taken a union. The \eqn{W} and \eqn{H.norm} matrices are not taken into
account for now.
}

\examples{
# Methods for base generics
pbmcPlot
print(pbmcPlot)
dim(pbmcPlot)
ncol(pbmcPlot)
colnames(pbmcPlot)[1:5]
pbmcPlot[varFeatures(pbmcPlot)[1:10], 1:10]
names(pbmcPlot)
length(pbmcPlot)

# rliger generics
## Retrieving dataset(s), replacement methods available
datasets(pbmcPlot)
dataset(pbmcPlot, "ctrl")
dataset(pbmcPlot, 2)

## Retrieving cell metadata, replacement methods available
cellMeta(pbmcPlot)
head(pbmcPlot[["nUMI"]])

## Retrieving dimemtion reduction matrix
head(dimRed(pbmcPlot, "UMAP"))

## Retrieving variable features, replacement methods available
varFeatures(pbmcPlot)

## Command record/history
pbmcPlot <- scaleNotCenter(pbmcPlot)
commands(pbmcPlot)
commands(pbmcPlot, funcName = "scaleNotCenter")

# S3 methods
pbmcPlot2 <- pbmcPlot
names(pbmcPlot2) <- paste0(names(pbmcPlot), 2)
c(pbmcPlot, pbmcPlot2)

library(ggplot2)
ggplot(pbmcPlot, aes(x = UMAP_1, y = UMAP_2)) + geom_point()
cellMeta(pbmc)
# Add new variable
pbmc[["newVar"]] <- 1
cellMeta(pbmc)
# Change existing variable
pbmc[["newVar"]][1:3] <- 1:3
cellMeta(pbmc)
}
