% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_product_properties.R
\name{get_product_properties}
\alias{get_product_properties}
\title{Get All Properties for a List of Product Ids}
\usage{
get_product_properties(rev_product_ids, rev_session_id, rev_username)
}
\arguments{
\item{rev_product_ids}{A vector of revulytics product id's for which
you want active user data.}

\item{rev_session_id}{Session ID established by the connection to
Revulytics API. This can be obtained with revulytics_auth().}

\item{rev_username}{Revulytics username.}
}
\value{
Data frame with properties and property attributes by
product id.
}
\description{
Returns all of the unique properties (standard and custom)
for each product id by property category.
}
\details{
It is not recommended that your username be stored directly in your
code. There are various methods and packages available that are more 
secure; this package does not require you to use any one in particular.
}
\examples{
\dontrun{
rev_user <- "my_username"
rev_pwd <- "super_secret"
product_ids_list <- c("123", "456", "789")
session_id <- revulytics_auth(rev_user, rev_pwd)  
product_properties <- get_product_properties(product_ids_list, session_id, rev_user)
}
}
