% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_range_to_values.R
\name{na_range_to_values}
\alias{na_range_to_values}
\title{Harmonize SPSS-style missing value ranges}
\usage{
na_range_to_values(x)
}
\arguments{
\item{x}{A labelled vector created with
[haven::labelled_spss()] or
`retroharmonize_labelled_spss_survey`.}
}
\value{
The input vector with harmonized `na_values` and `na_range`
attributes. If no harmonization is needed, `x` is returned
unchanged.
}
\description{
Ensure consistency between SPSS-style missing value ranges
(`na_range`) and explicit missing values (`na_values`)
for labelled survey vectors.
}
\details{
When both attributes are present, this function:
\itemize{
  \item adjusts the missing range if it conflicts with existing missing values,
  \item derives missing values from the range when necessary,
  \item leaves non-SPSS-labelled vectors unchanged.
}

This harmonization is important before joining, binding, or
summarizing survey data.
}
\seealso{
[labelled::na_range()],
[labelled::na_values()],
[as_numeric()]

Other variable label harmonization functions: 
\code{\link{label_normalize}()}
}
\concept{variable label harmonization functions}
