% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reviewInvalidRecords.R
\name{reviewInvalidRecords}
\alias{reviewInvalidRecords}
\title{Review Invalid Records Following Field Validation}
\usage{
reviewInvalidRecords(data, quiet = TRUE)
}
\arguments{
\item{data}{\code{data.frame}. The result of a function that performed
field validation.}

\item{quiet}{\code{logical(1)}. When \code{TRUE}, a message will be printed
if the \code{invalid} attribute is not found on \code{data}. Otherwise,
the message is suppressed.}
}
\value{
If \code{data} has the \code{"invalid"} attribute, an object with class
\code{c("invalid", "data.frame")} is returned. (\code{NULL} will be returned if
\code{data} does not have the attribute).

The colums in the Invalid data frame are\tabular{ll}{
    \tab  \cr
   \code{row} \tab The row number from the Records data frame for which validation failed. \cr
   \code{record_id} \tab The record ID for the failed validation. \cr
   \code{field_name} \tab The field name (column) of the failed validation. \cr
   \code{field_type} \tab The field type of the failed validation. \cr
   \code{value} \tab The original value that failed validation. It will be replaced with \code{NA} in the Records data. \cr
}


The Invalid data frame has additional attributes
\itemize{
\item \code{time} - The date/time at which the validation was performed.
\item \code{version} - The REDCap version number (as retrieved by \code{exportVersion}).
\item \code{project} - The title of the REDCap project (as retrieved by \code{exportProjectInformation}).
}
}
\description{
This function retrieves a summary of data elements that
failed validation during field validation and casting.
}
\details{
When discussing field validation and invalid data, it is helpful to
establish the following terminology:

A \emph{Records data frame} is a data frame returned by a function
where the fields (columns) in the data frame have been cast for
subsequent analysis.

Some casting function also perform field validation and return an
\emph{Invalid data frame}, which is a listing of data elements that
have failed validation. The Invalid data frame is attached as an
attribute to the Records data frame. If no data elements fail the
validation, the Invalid data frame will have zero rows. If at least
one data element fails validation, a warning is printed to notify
the user so that the user may review the Invalid data frame and
mitigate the failed validations.

The Invalid data frame has an additional class (\code{c("invalid", "data.frame")})
and comes with a print method. The \code{print.invalid} method displays the
content of the Invalid data frame neatly in both the console
and within reports utilizing markdown.
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"),
             url = "your_redcap_url",
             keyring = "API_KEYs",
             envir = globalenv())

# Review the Invalid data frame after export
Records <- exportRecordsTyped(rcon)
reviewInvalidRecords(Records)



# Review Invalid data frame before import
Records <- castForImport(rcon)
reviewInvalidRecords(Records)



# Access the Invalid data frame the attributes
Records <- exportRecordsTyped(rcon)
attr(Records, "invalid")
attributes(Records)$invalid
}

}
\seealso{
\code{\link[=exportRecordsTyped]{exportRecordsTyped()}}, \cr
\code{\link[=exportReportsTyped]{exportReportsTyped()}}, \cr
\code{\link[=castForImport]{castForImport()}}, \cr
\code{\link[=guessCast]{guessCast()}}
}
