% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simEvent.R
\name{parametrize}
\alias{parametrize}
\title{Parametrizations of Covariates and Covariate Coefficients}
\usage{
parametrize(z, zCoef, FUN = c("exponential", "linear", "excess"), ...)
}
\arguments{
\item{z}{A numeric matrix, each row of which represents the covariate vector
at one perticular time point.}

\item{zCoef}{A numeric matrix, each row of which represents the covariate
coeffcient vector at one perticular time point.}

\item{FUN}{The parametrization of the model parameter(s) with covariates and
covariate coefficients. The built-in options include
\code{"exponential"}, \code{"linear"}, \code{"excess"} for
parametrization in the exponential, linear, excess relative risk model
form, respectively. It can also be a function that at least has argument
\code{z} and \code{zCoef} for incorporating the covariates and covariate
coefficients into the model. The user-specified function should expect
that both the input \code{z} and \code{zCoef} are numeric vectors and
return a numeric value (or can be convected to a numeric value by
\code{as.numeric}).}

\item{...}{Other arguments that can be passed to the function \code{FUN}.}
}
\value{
A numeric vector.
}
\description{
This function helps the parametrizations of covariates and covariate
coeffcients when users specify a general hazard rate function in function
\code{simEvent} and \code{simEventData}. It applies the specified function
(or the built-in option) \code{FUN} to the \eqn{i_{th}} row of the covariate
matrix \code{z} and the \eqn{i_{th}} row of the coefficient matrix,
iteratively, for \eqn{i} from one to the number of rows of the covariate
matrix \code{z}.
}
\examples{
## time points
timeVec <- c(0.5, 2)
## time-variant covariates
zMat <- cbind(0.5, ifelse(timeVec > 1, 1, 0))
## time-varying coefficients
zCoefMat <- cbind(sin(timeVec), timeVec)

## the following three ways are equivalent for the exponential form,
## where the first one (using the built-in option) has the best performance
parametrize(zMat, zCoefMat, FUN = "exponential")
parametrize(zMat, zCoefMat, function(z, zCoef) exp(z \%*\% zCoef))
sapply(1 : 2, function(i) as.numeric(exp(zMat[i, ] \%*\% zCoefMat[i, ])))

}
\seealso{
\code{simEvent}
}
