% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_resolve_pkg_path.R
\name{resolve_pkg_path}
\alias{resolve_pkg_path}
\title{Resolve the path to a package directory or tarball}
\usage{
resolve_pkg_path(
  pkg,
  cache_path = NULL,
  force_fetch = FALSE,
  repos = getOption("rdocdump.repos", getOption("repos"))
)
}
\arguments{
\item{pkg}{A \code{character} string specifying the package. This can be:
\itemize{
\item an installed package name,
\item a full path to a package source directory,
\item a full path to a package archive file (tar.gz), or
\item a package name not installed (which will then be downloaded from CRAN).
}}

\item{cache_path}{A \code{character} string specifying the directory where kept temporary files will be stored.
By default, it uses the value of \code{getOption("rdocdump.cache_path")} which sets the cache directory to the temporary directory of the current R session.}

\item{force_fetch}{\code{logical}. If \code{TRUE}, the package source will be fetched from CRAN as a tar.gz archive even if the package is already installed locally. Default is \code{FALSE}.}

\item{repos}{A \code{character} vector of repository URLs. By default, it uses the value of \code{getOption("rdocdump.repos")} which sets the repository URLs to the default R repositories and is itself set to \code{c("CRAN" = "https://cloud.r-project.org")} on package load to prevent accidental downloads of pre-built packages from Posit Package Manager and R Universe.}
}
\value{
A list containing:
\itemize{
\item \code{pkg_path}: Path to the package directory or tarball.
\item \code{extracted_path}: Path to the extracted package directory (if applicable).
\item \code{tar_path}: Path to the tarball if it was downloaded.
\item \code{is_installed}: Logical indicating if the package is installed.
}
}
\description{
This function resolves the path to a package directory or tarball, handling both installed packages and source packages from CRAN.
}
\keyword{internal}
