% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbc.R
\name{gbc}
\alias{gbc}
\title{Gamma back correction}
\usage{
gbc(DN_from_JPEG, gamma = 2.2)
}
\arguments{
\item{DN_from_JPEG}{Numeric vector or object of the \linkS4class{SpatRaster}
class. Digital numbers from a JPEG file (0 to 255, i.e., the standard 8-bit
encoded).}

\item{gamma}{Numeric vector of length one. Gamma value. Please see
\insertCite{Diaz2018;textual}{rcaiman} for details.}
}
\value{
The same class as \code{DN_from_JPEG}, with dimension unchanged but values
rescaled between \code{0} and \code{1} in a non-linear fashion.
}
\description{
Gamma back correction of JPEG images
}
\details{
Digital cameras usually use sRGB as color space. It is a standard
developed to ensure accurate color and tone management. The transfer function
of sRGB, known as gamma correction, is very close to a power function with
the exponent 1/2.2. This is why a DN of a born-digital photograph that was
encoded in sRGB has a non-linear relationship with luminance despite
having the sensor a linear response.
}
\examples{
path <- system.file("external/DSCN4500.JPG", package = "rcaiman")
r <- read_caim(path, c(1250, 1020) - 745, 745 * 2, 745 * 2)
r
gbc(r)
}
\references{
\insertAllCited{}
}
\seealso{
Other Pre-processing Functions: 
\code{\link{enhance_caim}()},
\code{\link{local_fuzzy_thresholding}()},
\code{\link{membership_to_color}()},
\code{\link{normalize}()}
}
\concept{Pre-processing Functions}
