% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2d.R
\name{gen_edges}
\alias{gen_edges}
\title{Generate edge information}
\usage{
gen_edges(tri_object, a1)
}
\arguments{
\item{tri_object}{The triangular object from which to generate edge information.}

\item{a1}{A numeric value for bin width.}
}
\value{
A tibble that contains the edge information, including the from-to
relationships and the corresponding x and y coordinates.
}
\description{
This function generates edge information from a given triangular object,
including the coordinates of the vertices and the from-to relationships
between the vertices.
}
\examples{
all_centroids_df <- scurve_model_obj$hb_obj$centroids
counts_data <- scurve_model_obj$hb_obj$std_cts
umap_with_hb_id <- scurve_model_obj$hb_obj$data_hb_id
df_bin_centroids <- extract_hexbin_centroids(counts_data = counts_data,
centroids_data = all_centroids_df)
tr1_object <- tri_bin_centroids(centroids_data = df_bin_centroids)
gen_edges(tri_object = tr1_object, a1 = scurve_model_obj$hb_obj$a1)

}
