% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutations.R
\name{permutations}
\alias{permutations}
\alias{print.qtlpoly.perm}
\alias{plot.qtlpoly.perm}
\title{Fixed-effect interval mapping (FEIM) model permutations}
\usage{
permutations(
  data,
  offset.data = NULL,
  pheno.col = NULL,
  n.sim = 1000,
  probs = c(0.9, 0.95),
  n.clusters = NULL,
  seed = 123,
  verbose = TRUE
)

\method{print}{qtlpoly.perm}(x, pheno.col = NULL, probs = c(0.9, 0.95), ...)

\method{plot}{qtlpoly.perm}(x, pheno.col = NULL, probs = c(0.9, 0.95), ...)
}
\arguments{
\item{data}{an object of class \code{qtlpoly.data}.}

\item{offset.data}{a subset of the data object to be used in permutation calculations.}

\item{pheno.col}{a numeric vector with the phenotype columns to be analyzed; if \code{NULL} (default), all phenotypes from \code{'data'} will be included.}

\item{n.sim}{a number of simulations, e.g. 1000 (default).}

\item{probs}{a vector of probability values in [0, 1] representing the quantiles, e.g. c(0.90, 0.95) for the 90\% and 95\% quantiles.}

\item{n.clusters}{a number of parallel processes to spawn.}

\item{seed}{an integer for the \code{set.seed()} function; if \code{NULL}, no reproducible seeds are set.}

\item{verbose}{if \code{TRUE} (default), current progress is shown; if \code{FALSE}, no output is produced.}

\item{x}{an object of class \code{qtlpoly.perm} to be printed or plotted.}

\item{...}{currently ignored}
}
\value{
An object of class \code{qtlpoly.perm} which contains a list of \code{results} for each trait with the maximum LOD score per permutation.

LOD score thresholds for given quantiles for each trait.

A \pkg{ggplot2} histogram with the distribution of ordered maximum LOD scores and thresholds for given quantiles for each trait.
}
\description{
Stores maximum LOD scores for a number of permutations of given phenotypes.
}
\examples{
  \donttest{
  # Estimate conditional probabilities using mappoly package
  library(mappoly)
  library(qtlpoly)
  genoprob4x = lapply(maps4x[c(5)], calc_genoprob)
  data = read_data(ploidy = 4, geno.prob = genoprob4x, pheno = pheno4x, step = 1)

  # Perform permutations
  perm = permutations(data = data, pheno.col = 1, n.sim = 10, n.clusters = 1)
  }

}
\references{
Churchill GA, Doerge RW (1994) Empirical threshold values for quantitative trait mapping, \emph{Genetics} 138: 963-971.

    Pereira GS, Gemenet DC, Mollinari M, Olukolu BA, Wood JC, Mosquera V, Gruneberg WJ, Khan A, Buell CR, Yencho GC, Zeng ZB (2020) Multiple QTL mapping in autopolyploids: a random-effect model approach with application in a hexaploid sweetpotato full-sib population, \emph{Genetics} 215 (3): 579-595. \doi{10.1534/genetics.120.303080}.
}
\seealso{
\code{\link[qtlpoly]{feim}}
}
\author{
Guilherme da Silva Pereira, \email{gdasilv@ncsu.edu}
}
