% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.psc.count.R
\name{plot.psc.count}
\alias{plot.psc.count}
\title{Function for Plotting PSC objects
#' A function which illsutrates the predicted response under the counter factual
model and the observed response under the experimental treatment(s).}
\usage{
\method{plot}{psc.count}(x, ...)
}
\arguments{
\item{x}{an object of class 'psc'}

\item{...}{not used}
}
\value{
a survival plot corresponding to the psc fit
}
\description{
Function for Plotting PSC objects
#' A function which illsutrates the predicted response under the counter factual
model and the observed response under the experimental treatment(s).
}
\details{
This function plots the expected response of the control treatment
   along with the observe response rates of the experimental arms
}
\examples{
count.mod <- psc::count.mod
data <- psc::data
count.psc <- pscfit(count.mod,data,nsim=3000)
plot(count.psc)
}
