% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_rule.R, R/check_rules.R
\name{check_rule}
\alias{check_rule}
\alias{check_rule.log}
\alias{check_rules}
\alias{check_rules.log}
\title{Check Declarative Rule(s)}
\usage{
check_rule(log, rule, label = NULL, eventlog = deprecated())

\method{check_rule}{log}(log, rule, label = NULL, eventlog = deprecated())

check_rules(log, ..., eventlog = deprecated())

\method{check_rules}{log}(log, ..., eventlog = deprecated())
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{rule}{A rule created by a rule function.}

\item{label}{\code{\link{character}} (default \code{\link{NULL}}): Optionally, the column name under which the result of the rule should be stored.}

\item{eventlog}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{log} instead.}

\item{...}{Name-rule pairs created by rule functions.}
}
\value{
An annotated log (of same type as input), where – for every rule – a new column indicates whether the rule holds or not.
The name of the new column can optionally be set using the \code{label} argument, or by the name of each rule in the name-rule pairs.
}
\description{
This function can be used to check rules or constraint templates on event data.
It needs a \code{log} (object of class \code{\link[bupaR]{log}} or derivatives, e.g. \code{\link[bupaR]{grouped_log}},
\code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.). and (a) \code{rule}(s).
Rules can be made with the following templates:
\itemize{
\item \emph{Cardinality}:
\itemize{
\item \code{\link{absent}}: Check if the specified activity is absent from a case,
\item \code{\link{contains}}: Check if the specified activity is present (contained) in a case,
\item \code{\link{contains_between}}: Check if the specified activity is present (contained) in a case between the minimum and maximum number of times,
\item \code{\link{contains_exactly}}: Check if the specified activity is present (contained) in a case for exactly \code{n} times.
}
\item \emph{Relation}:
\itemize{
\item \code{\link{ends}}: Check if cases end with the specified activity,
\item \code{\link{starts}}: Check if cases start with the specified activity.
\item \code{\link{precedence}}: Check for precedence between two activities,
\item \code{\link{response}}: Check for response between two activities,
\item \code{\link{responded_existence}}: Check for responded existence between two activities,
\item \code{\link{succession}}: Check for succession between two activities.
}
\item \emph{Exclusiveness}:
\itemize{
\item \code{\link{and}}: Check for co-existence of two activities,
\item \code{\link{xor}}: Check for exclusiveness of two activities.
}
}
}
\details{
The rules or constraint templates in this package are (partially) based on \emph{DecSerFlow} (\emph{Declarative Service Flow Language}).
For more information, see the \strong{References} below.
\subsection{Grouped Logs}{

When applied to a \code{\link[bupaR]{grouped_log}}, the grouping variables are ignored but retained in the returned log.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{check_rule(log)}: Check rule on a \code{\link[bupaR]{log}}.

}}
\section{Functions}{
\itemize{
\item \code{check_rules(log)}: Check rules on a \code{\link[bupaR]{log}}.

}}
\examples{
library(bupaR)
library(eventdataR)

# Check whether MRI Scan is preceded by Blood test.
patients \%>\%
 check_rule(precedence("Blood test","MRI SCAN"))

# Check whether MRI Scan is preceded by Blood test, and the case starts with Registration.
patients \%>\%
 check_rules(rule1 = precedence("Blood test","MRI SCAN"),
             rule2 = starts("Registration"))

}
\references{
van der Aalst, W. M. P., & Pesic, M. (2006). DecSerFlow: Towards a Truly Declarative Service Flow Language.
In M. Bravetti, M. Núñez, & G. Zavattaro (Eds.), Proceedings of the 3rd International Workshop on Web Services and Formal Methods (Vol. 4184, pp. 1–23).
Springer. \doi{10.1007/11841197_1}
}
\seealso{
\code{\link{filter_rules}}
}
