% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Solver-class.R
\name{Solver-class}
\alias{Solver-class}
\alias{Solver}
\title{Solver class}
\description{
This class is used to represent solvers for optimization.
\strong{Only experts should use the fields and methods for this class directly.}
}
\seealso{
Other classes: 
\code{\link{ConservationModifier-class}},
\code{\link{ConservationProblem-class}},
\code{\link{Constraint-class}},
\code{\link{Decision-class}},
\code{\link{Objective-class}},
\code{\link{OptimizationProblem-class}},
\code{\link{Penalty-class}},
\code{\link{Portfolio-class}},
\code{\link{Target-class}}
}
\concept{classes}
\section{Super class}{
\code{\link[prioritizr:ConservationModifier]{prioritizr::ConservationModifier}} -> \code{Solver}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Solver-run}{\code{Solver$run()}}
\item \href{#method-Solver-calculate}{\code{Solver$calculate()}}
\item \href{#method-Solver-set_variable_ub}{\code{Solver$set_variable_ub()}}
\item \href{#method-Solver-set_variable_lb}{\code{Solver$set_variable_lb()}}
\item \href{#method-Solver-set_constraint_rhs}{\code{Solver$set_constraint_rhs()}}
\item \href{#method-Solver-set_start_solution}{\code{Solver$set_start_solution()}}
\item \href{#method-Solver-solve}{\code{Solver$solve()}}
\item \href{#method-Solver-clone}{\code{Solver$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="prioritizr" data-topic="ConservationModifier" data-id="get_data"><a href='../../prioritizr/html/ConservationModifier.html#method-ConservationModifier-get_data'><code>prioritizr::ConservationModifier$get_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="prioritizr" data-topic="ConservationModifier" data-id="get_internal"><a href='../../prioritizr/html/ConservationModifier.html#method-ConservationModifier-get_internal'><code>prioritizr::ConservationModifier$get_internal()</code></a></span></li>
<li><span class="pkg-link" data-pkg="prioritizr" data-topic="ConservationModifier" data-id="print"><a href='../../prioritizr/html/ConservationModifier.html#method-ConservationModifier-print'><code>prioritizr::ConservationModifier$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="prioritizr" data-topic="ConservationModifier" data-id="repr"><a href='../../prioritizr/html/ConservationModifier.html#method-ConservationModifier-repr'><code>prioritizr::ConservationModifier$repr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="prioritizr" data-topic="ConservationModifier" data-id="set_data"><a href='../../prioritizr/html/ConservationModifier.html#method-ConservationModifier-set_data'><code>prioritizr::ConservationModifier$set_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="prioritizr" data-topic="ConservationModifier" data-id="set_internal"><a href='../../prioritizr/html/ConservationModifier.html#method-ConservationModifier-set_internal'><code>prioritizr::ConservationModifier$set_internal()</code></a></span></li>
<li><span class="pkg-link" data-pkg="prioritizr" data-topic="ConservationModifier" data-id="show"><a href='../../prioritizr/html/ConservationModifier.html#method-ConservationModifier-show'><code>prioritizr::ConservationModifier$show()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Solver-run"></a>}}
\if{latex}{\out{\hypertarget{method-Solver-run}{}}}
\subsection{Method \code{run()}}{
Run the solver to generate a solution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Solver$run()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{list} of solutions.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Solver-calculate"></a>}}
\if{latex}{\out{\hypertarget{method-Solver-calculate}{}}}
\subsection{Method \code{calculate()}}{
Perform computations that need to be completed before applying
the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Solver$calculate(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional arguments.}

\item{\code{x}}{\code{\link[=optimization_problem]{optimization_problem()}} object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible \code{TRUE}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Solver-set_variable_ub"></a>}}
\if{latex}{\out{\hypertarget{method-Solver-set_variable_ub}{}}}
\subsection{Method \code{set_variable_ub()}}{
Set the upper bound for a decision variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Solver$set_variable_ub(index, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{\code{integer} value indicating the index of the decision
variable.}

\item{\code{value}}{\code{numeric} new bound value.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Note that this method should only be run after \verb{$calculate()}.
It can be used to overwrite values after ingesting an
\code{\link[=optimization_problem]{optimization_problem()}} object.
It is designed to be used in \link{portfolios} and \link{importance} functions.
}

\subsection{Returns}{
Invisible \code{TRUE}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Solver-set_variable_lb"></a>}}
\if{latex}{\out{\hypertarget{method-Solver-set_variable_lb}{}}}
\subsection{Method \code{set_variable_lb()}}{
Set the lower bound for a decision variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Solver$set_variable_lb(index, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{\code{integer} value indicating the index of the decision
variable.}

\item{\code{value}}{\code{numeric} new bound value.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Note that this method should only be run after \verb{$calculate()}.
It can be used to overwrite values after ingesting an
\code{\link[=optimization_problem]{optimization_problem()}} object.
It is designed to be used in \link{portfolios} and \link{importance} functions.
}

\subsection{Returns}{
Invisible \code{TRUE}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Solver-set_constraint_rhs"></a>}}
\if{latex}{\out{\hypertarget{method-Solver-set_constraint_rhs}{}}}
\subsection{Method \code{set_constraint_rhs()}}{
Set the right-hand-side coefficient bound for a constraint.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Solver$set_constraint_rhs(index, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{\code{integer} value indicating the index of the decision
variable.}

\item{\code{value}}{\code{numeric} new value.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Note that this method should only be run after \verb{$calculate()}.
It can be used to overwrite values after ingesting an
\code{\link[=optimization_problem]{optimization_problem()}} object.
It is designed to be used in \link{portfolios} and \link{importance} functions.
}

\subsection{Returns}{
Invisible \code{TRUE}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Solver-set_start_solution"></a>}}
\if{latex}{\out{\hypertarget{method-Solver-set_start_solution}{}}}
\subsection{Method \code{set_start_solution()}}{
Set the starting solution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Solver$set_start_solution(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{\code{numeric} new value.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Note that this method should only be run after \verb{$calculate()}.
It can be used to overwrite values after ingesting an
\code{\link[=optimization_problem]{optimization_problem()}} object.
It is designed to be used in \link{portfolios} and \link{importance} functions.
}

\subsection{Returns}{
Invisible \code{TRUE}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Solver-solve"></a>}}
\if{latex}{\out{\hypertarget{method-Solver-solve}{}}}
\subsection{Method \code{solve()}}{
Solve an optimization problem.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Solver$solve(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\code{\link[=optimization_problem]{optimization_problem()}} object.}

\item{\code{...}}{Additional arguments passed to the \code{calculate()} method.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible \code{TRUE}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Solver-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Solver-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Solver$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
