% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winther_ptp.R
\name{calculate_winther_2020_basic_ptp}
\alias{calculate_winther_2020_basic_ptp}
\title{Calculate 2020 Winther Basic PTP for obstructive CAD}
\usage{
calculate_winther_2020_basic_ptp(age, sex, chest_pain_type)
}
\arguments{
\item{age}{Input numeric value to indicate the age of the patient.}

\item{sex}{Input characters (female, male) to indicate the sex of the patient.
\itemize{
  \item female
  \item male
}}

\item{chest_pain_type}{Input characters (no chest pain, typical, atypical, nonanginal)
to indicate the chest pain characteristics of the patient.
\itemize{
  \item no chest pain stands for the patient having no chest pain.
  \item typical stands for the patient having typical chest pain.
  \item atypical stands for the patient having atypical chest pain.
  \item nonanginal stands for the patient having nonanginal or non-specific chest pain.
}}
}
\value{
A numeric value representing the patient's PTP for obstructive CAD
based on the 2020 Winther et. al. basic model (Basic_PTP).
}
\description{
This function returns a patient's
pre-test probability (PTP) of obstructive
coronary artery disease based on the
2020 Winther et. al. basic model (Basic_PTP).
}
\details{
The predictive model is based on > 40000 symptomatic
patients from 2008 to 2017 from 13 hospitals in Western Denmark. These
patients are registered under the Western Denmark Heart Registry.
}
\examples{
# 40 year old Male with typical chest pain
calculate_winther_2020_basic_ptp(
    age = 40,
    sex = "male",
    chest_pain_type = "typical"
)

# 40 year old Male with nonanginal chest pain
calculate_winther_2020_basic_ptp(
    age = 40,
    sex = "male",
    chest_pain_type = "nonanginal"
)
}
