% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_data_functions.R
\name{get_id_stage}
\alias{get_id_stage}
\title{Get IDs and Stages}
\usage{
get_id_stage(object, event_set = c(0))
}
\arguments{
\item{object}{Object of class \link{policy_data} or \link{history}.}

\item{event_set}{Integer vector. Subset of c(0,1,2).}
}
\value{
\link[data.table:data.table]{data.table::data.table} with keys id and stage.
}
\description{
\code{get_id_stage} returns the ID and stage number differnt types of events.
}
\examples{
### Two stages:
d <- sim_two_stage(5e2, seed=1)
# constructing policy_data object:
pd <- policy_data(d,
                  action = c("A_1", "A_2"),
                  baseline = c("B"),
                  covariates = list(L = c("L_1", "L_2"),
                                    C = c("C_1", "C_2")),
                  utility = c("U_1", "U_2", "U_3"))
pd

# getting the IDs and stages:
head(get_id_stage(pd))
}
