% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{utils_pca}
\alias{utils_pca}
\alias{pca}
\alias{get_biplot}
\alias{plot.pca}
\title{Utilities for Principal Component Axis analysis}
\usage{
pca(x, scale = TRUE)

get_biplot(
  x,
  axes = c(1, 2),
  show = c("both"),
  show_ind_id = TRUE,
  show_unit_circle = TRUE,
  expand = NULL
)

\method{plot}{pca}(x, type = "var", which = "contrib", axis = 1, ...)
}
\arguments{
\item{x}{\itemize{
\item For \code{pca()}, a numeric or complex matrix (or data frame) which provides the
data for the principal components analysis.
\item For \code{plot.pca()} and \code{get_biplot()}, an object computed with \code{pca()}.
}}

\item{scale}{A logical value indicating whether the variables should be
scaled to have unit variance before the analysis takes place. Defaults to
\code{TRUE}.}

\item{axes}{The principal component axes to plot. Defaults to \code{axes = c(1, 2)},
i.e., the first and second interaction principal component axis.}

\item{show}{Which to show in the biplot. Defaults to \code{"both"} (both variables
and individuals). One can also use \code{"var"}, or \code{"ind"}.}

\item{show_ind_id}{Shows the labels for individuals? Defaults to \code{TRUE}.}

\item{show_unit_circle}{Shows the unit variance circle? Defaults to \code{TRUE}.}

\item{expand}{An expansion factor to apply when plotting the second set of
points relative to the first. This can be used to tweak the scaling of the
two sets to a physically comparable scale. Setting to \code{TRUE} will
automatically compute the expansion factor. Alternatively, a numeric value
can be informed.}

\item{type}{One of \code{"var"} (to plot variables), \code{"ind"} (to plot
individuals), or \code{"biplot"} to create a biplot.}

\item{which}{Which measure to plot. Either \code{which = "contribution"}
(default),  \code{which = "cos2"} (quality of representation), or \code{which = "coord"} (coordinates)}

\item{axis}{The axist to plot the contribution/cos2. Defaults to 1.}

\item{...}{Further arguments passed on to \code{\link[=get_biplot]{get_biplot()}} when \code{type = "biplot"}. Otherwise, When \code{which = "coord"}, further arguments passed on
to \code{\link[=get_biplot]{get_biplot()}}. When \code{which = "contrib"}, or \code{which = "cos2"} further
arguments passed on to \code{\link[graphics:barplot]{graphics::barplot()}}.}
}
\value{
\itemize{
\item \code{pca()} returns a list including:
\itemize{
\item \code{data}: The raw data used to compute the PCA.
\item \code{variances}: Variances (eigenvalues), and proportion of explained
variance for each component.
\item \verb{center,scale}: the centering and scaling used.
\item \verb{ind,var} A list with the following objects for individuals/variables, respectively.
\item \code{coord}: coordinates for the individuals/variables (loadings * the
component standard deviations)
\item \code{cos2}: cos2 for the individuals/variables (coord^2)
\item \code{contrib}: The contribution  (in percentage) of a variable to a given
principal component: (cos2 * 100) / (total cos2 of the component)
}
\item \code{plot.pca()} returns a list with the coordinates used.
\item \code{get_biplot()} returns a \code{NULL} object
}
}
\description{
\itemize{
\item \code{pca()} Computes a Principal Component Analysis. It wrappers
\code{\link[stats:prcomp]{stats::prcomp()}}, but returns more results such as data, scores,
contributions and quality of measurements for individuals and variables.
\item \code{get_biplot()}: Produces a biplot for an object computed with \code{pca()}.
\item \code{plot.pca()}: Produces several types of plots, depending on the \code{type} and \code{which}
arguments.
\itemize{
\item \code{type = "var"} Produces a barplot with the contribution (\code{which =  "contrib"}), qualitity of adjustment \code{which = "cos2"}, and a scatter plot
with coordinates (\code{which = "coord"}) for the variables.
\item \code{type = "ind"} Produces a barplot with the contribution (\code{which =  "contrib"}), qualitity of adjustment \code{which = "cos2"}, and a scatter plot
with coordinates (\code{which = "coord"}) for the individuals.
\item \code{type = "biplot"} Produces a biplot.
}
}
}
\examples{
library(pliman)
pc <- pca(mtcars[1:10 ,1:6])
plot(pc)
plot(pc, type = "ind")
plot(pc, type = "var", which = "coord")
plot(pc, type = "ind", which = "coord")
plot(pc, type = "biplot")
}
