% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mask.R
\name{make_brush}
\alias{make_brush}
\title{Makes a brush}
\usage{
make_brush(size, shape = "disc", ...)
}
\arguments{
\item{size}{A numeric containing the size of the brush in pixels. This should
be an odd number; even numbers are rounded to the next odd one.}

\item{shape}{A character vector indicating the shape of the brush. Can be
\code{"box"}, \code{"disc"}, \code{"diamond"}, \code{"Gaussian"} or \code{"line"} Defaults to
\code{"disc"}.}

\item{...}{Further arguments passed on to \code{\link[EBImage:morphology]{EBImage::makeBrush()}}.}
}
\value{
A 2D matrix of 0s and 1s containing the desired brush.
}
\description{
Generates brushes of various sizes and shapes that can be used as structuring
elements. See \code{\link[EBImage:morphology]{EBImage::makeBrush()}}.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
make_brush(size = 51) |> image()
make_brush(size = 51, shape = "diamond") |> image()
}
}
