% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{image_to_mat}
\alias{image_to_mat}
\title{Convert an image to a data.frame}
\usage{
image_to_mat(img, parallel = FALSE, workers = NULL, verbose = TRUE)
}
\arguments{
\item{img}{An image object.}

\item{parallel}{Processes the images asynchronously (in parallel) in separate
R sessions running in the background on the same machine. It may speed up
the processing time when \code{image} is a list. The number of sections is set
up to 70\% of available cores.}

\item{workers}{A positive numeric scalar or a function specifying the maximum
number of parallel processes that can be active at the same time.}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}
}
\value{
A list containing three matrices (R, G, and B), and a data frame
containing four columns: the name of the image in \code{image} and the R, G, B
values.
}
\description{
Given an object image, converts it into a data frame where each row corresponds to the intensity values of each pixel in the image.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
img <- image_pliman("sev_leaf.jpg")
dim(img)
mat <- image_to_mat(img)
dim(mat[[1]])
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
