% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purple.r
\name{Purple}
\alias{Purple}
\title{Constructor of purple waveband}
\usage{
Purple(std = "ISO")
}
\arguments{
\item{std}{a character string "ISO", or Landsat imager "LandsatOLI".}
}
\value{
A waveband object defining a wavelength range.
}
\description{
Wavelength-range definition for \emph{purple} radiation according to ISO or
imagers in the Landsat satellites.
}
\details{
Purple (or violet) wavelengths as defined by ISO standards based on
   human vision overlap the UVA band as defined by a separate ISO standard.
   In other contexts like plant photobiology purple is included under blue,
   while some overoptimistic LED sellers call LEDs emitting in the violet
   region ultraviolet LEDs. In addition to the ISO definition of purple,
   a purple channel from Landsat imagers is implemented.
}
\examples{
Purple()
Purple("ISO")

e_irrad(sun.spct, Purple()) # W m-2
q_irrad(sun.spct, Purple()) # mol m-2
q_irrad(sun.spct, Purple(), scale.factor = 1e6) # umol m-2

}
\seealso{
\code{\link{new_waveband}}  \code{\link{waveband}}

Other unweighted wavebands: 
\code{\link{Blue}()},
\code{\link{Far_red}()},
\code{\link{Green}()},
\code{\link{IR}()},
\code{\link{Orange}()},
\code{\link{Red}()},
\code{\link{UVA}()},
\code{\link{UVB}()},
\code{\link{UVC}()},
\code{\link{UV}()},
\code{\link{VIS}()},
\code{\link{Yellow}()}
}
\concept{unweighted wavebands}
