% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.metadata.r
\name{isValidInstrDesc}
\alias{isValidInstrDesc}
\title{Check the "instr.desc" attribute}
\usage{
isValidInstrDesc(x)
}
\arguments{
\item{x}{a \code{generic_spct} object or a \code{summary_generic_spct}
object.}
}
\value{
A \code{logical} vector of length one.
}
\description{
Function to validate the \code{"instr.settings"} attribute of an existing
\code{generic_spct} object or \code{summary_generic_spct} object.
}
\details{
Test if at least one of instrument name (field
 \code{spectrometer.name}) or serial number (field \code{spectrometer.sn})
 is found in the value of the R attribute \code{"instr.desc"} of \code{x}.
 \code{FALSE} is silently returned if \code{x} does not belong to a class
 derived from class \code{generic_spct} or from class
 \code{summary_generic_spct}, or if it is derived from these classes but the
 attribute is not set.
}
\examples{
isValidInstrDesc(white_led.cps_spct)
isValidInstrDesc(white_body.spct)

}
\seealso{
Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{subset_attributes}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
