% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsc.R
\name{pgsc}
\alias{pgsc}
\title{Wrapper function for GSC estimation}
\usage{
pgsc(dta, dep.var, indep.var, b.init, method, sol.it = NULL,
  wt.init = NULL, print.level = 0, g.i = NULL, g.i.grad = NULL,
  ...)
}
\arguments{
\item{dta}{A data frame}

\item{dep.var}{A string defining the dependent variable}

\item{indep.var}{A vector of strings defining the independent (treatment) variables}

\item{b.init}{An initial value for the treatment variable coefficients. Must have same 
length as `indep.var`}

\item{method}{The GSC iteration method to be used. Must be one of:
\itemize{
    \item{\code{onestep}: "Plain" GSC solution, without weights}
    \item{\code{twostep.aggte}: Observations weighted by unit MSEs from the one-step solution.}
    \item{\code{twostep.indiv}: Observations weighted by unit MSEs from individual, unit-by-unit unweighted solutions.}
}}

\item{sol.it}{The first step solution used in the two-step methods. If omitted, 
a new one-step solution is computed.}

\item{wt.init}{An initial value for the weighting matrix}

\item{print.level}{The level of detail provided in the printed output}

\item{g.i}{A function defining a restriction on the parameters.  Used in hypothesis testing.}

\item{g.i.grad}{The gradient of \code{g.i}.}

\item{...}{Other arguments to be passed to the optimization}
}
\value{
Returns the point estimate of the model as a \code{gsc} object, a list with entries:
\describe{
    \item{b}{The point estimate of the coefficients on the dependent variables}
    \item{diff}{The difference between successive iterations}
    \item{err}{The maximum error on the within-iteration optimization problems}
    \item{it}{Number of iterations require to solve}
    \item{sig.i}{The unit-specific MSEs from the solution}
    \item{W}{The "full" weighting matrix for counterfactuals, containing own-unit weights (all zero) and unit-N weights}
    \item{wt}{The "minimal" weighting matrix, omitting own-unit weights and weights on unit N (which can be computed as one-minus-rowsum)}
}
}
\description{
Wrapper function for GSC estimation
}
\details{
See the vignette "Using \code{pgsc}" for an extended example.
}
\examples{
data("pgsc.dta")
sol <- pgsc(pgsc.dta, dep.var = 'y', indep.var = c('D1','D2'), 
b.init = c(0,0), method='onestep' )
summary(sol)
g.i <- function(b) b[1] ; g.i.grad <- function(b) c(1,0)
sol.r <- pgsc(pgsc.dta, dep.var = 'y', indep.var = c('D1','D2'), 
b.init = sol$b, method='onestep', g.i=g.i, g.i.grad=g.i.grad )
summary(sol.r)
}
