% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_generation.R
\name{get_gene_sets_list}
\alias{get_gene_sets_list}
\title{Retrieve Organism-specific Gene Sets List}
\usage{
get_gene_sets_list(
  source = "KEGG",
  org_code = "hsa",
  species = "Homo sapiens",
  db_species = "HS",
  collection,
  subcollection = NULL
)
}
\arguments{
\item{source}{As of this version, either 'KEGG', 'Reactome' or 'MSigDB' (default = 'KEGG')}

\item{org_code}{(Used for 'KEGG' only) KEGG organism code for the selected organism. For a full list
of all available organisms, see \url{https://www.genome.jp/kegg/catalog/org_list.html}}

\item{species}{species name for output genes, such as Homo sapiens, Mus musculus, etc.
See \code{\link[msigdbr]{msigdbr_species}} for all the species available in
the msigdbr package.}

\item{db_species}{Species abbreviation for the human or mouse databases ("HS" or "MM").}

\item{collection}{collection. e.g., H, C1. (default = NULL,
i.e. list all gene sets in collection). 
See \code{\link[msigdbr]{msigdbr_collections}} for all available options
the msigdbr package.}

\item{subcollection}{sub-collection, such as CGP, BP, etc. (default = NULL,
i.e. list all gene sets in collection). 
See \code{\link[msigdbr]{msigdbr_collections}} for all available options
the msigdbr package.}
}
\value{
A list containing 2 elements: \itemize{
\item{gene_sets - A list containing the genes involved in each gene set}
\item{descriptions - A named vector containing the descriptions for each gene set}
}. For 'KEGG' and 'MSigDB', it is possible to choose a specific organism. For a full list
of all available KEGG organisms, see \url{https://www.genome.jp/kegg/catalog/org_list.html}.
See \code{\link[msigdbr]{msigdbr_species}} for all the species available in
the msigdbr package used for obtaining 'MSigDB' gene sets.
For Reactome, there is only one collection of pathway gene sets.
}
\description{
Retrieve Organism-specific Gene Sets List
}
