\name{abundances}
\alias{abundances}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Generates abundances
%%  ~~function to do ... ~~
}
\description{ Generates species abundances based on species response functions and environmental variables.  
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
abundances(env, spp, nc)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{env}{ Environmental variables. Usually generated by \code{\link{make.env}}. Users may as well supply own environmental variables. 
%%     ~~Describe \code{env} here~~
}
  \item{spp}{ Species parameters. Usually generated by \code{\link{species}}.
%%     ~~Describe \code{spp} here~~
}
  \item{nc}{  Number of counts to be simulated. If omitted no simulation of the counting process is carried out. 
%%     ~~Describe \code{nc} here~~
}
}
\value{ 
%%  ~Describe the value returned
%%  If it is a LIST, use
  \item{spp}{Data frame containing species abundances.}
  \item{env}{Data frame containing environmental variables.}
%% ...
}
\references{ Minchin, P.R. (1987) Multidimensional Community Patterns: Towards a Comprehensive Model. Vegetatio, 71, 145-156.

%% ~put references to the literature/web site here ~
}
\author{ Mathias Trachsel and Richard J Telford
%%  ~~who you are~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{\code{\link{make.env}}, \code{\link{species}}  
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
spec <- species(nspp = 30,ndim = 10,Amax = runif,fun = runif, xpar = c(-50,150),
    srange = 200, alpha = 4, gamma = 4)
env.var <- make.env(100,elen =rep(100,10),emean = rep(50,10), edistr ='uniform',
    ndim = 10)
spec.abun <- abundances(env.var,spec,200)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ datagen }
