% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{useOverlay}
\alias{useOverlay}
\title{Manually set up a Shiny app to use overshiny}
\usage{
useOverlay()
}
\value{
Returns an HTML dependency that sets up your Shiny app to use
\code{overshiny}.
}
\description{
\code{overshiny} will set up automatically if you have an \code{\link[=overlayPlotOutput]{overlayPlotOutput()}}
anywhere in your Shiny UI, which you probably do if you are using this
package. But if you don't, you can set up \code{overshiny} by manually putting
\code{\link[=useOverlay]{useOverlay()}} somewhere in your Shiny app's UI.
}
\details{
This also calls \code{\link[shinyjs:useShinyjs]{shinyjs::useShinyjs()}}, as \code{overshiny} depends on \code{shinyjs}.
}
\examples{
ui <- shiny::fluidPage(
    useOverlay() # only needed if no overlayPlotOutput() elements below
    # further UI elements here . . .
)

server <- function(input, output) {
    # server code here . . .
}

if (interactive()) {
    shiny::shinyApp(ui, server)
}

}
\seealso{
\code{\link[=overlayServer]{overlayServer()}}, for a complete example.
}
