% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-osmdata-xml.R
\name{osmdata_xml}
\alias{osmdata_xml}
\title{Return an OSM Overpass query in XML format
Read an (XML format) OSM Overpass response from a string, a connection,
or a raw vector.}
\usage{
osmdata_xml(q, filename, quiet = TRUE, encoding)
}
\arguments{
\item{q}{An object of class \code{overpass_query} constructed with
\link{opq} and \link{add_osm_feature}.}

\item{filename}{If given, OSM data are saved to the named file}

\item{quiet}{suppress status messages.}

\item{encoding}{Unless otherwise specified XML documents are assumed to be
encoded as UTF-8 or UTF-16. If the document is not UTF-8/16, and lacks
an explicit encoding directive, this allows you to supply a default.}
}
\value{
An object of class \code{xml2::xml_document} containing the result of the
overpass API query.
}
\description{
Return an OSM Overpass query in XML format
Read an (XML format) OSM Overpass response from a string, a connection,
or a raw vector.
}
\note{
Objects of class \code{xml_document} can be saved as \code{.xml} or
\code{.osm} files with \code{xml2::write_xml}.
}
\examples{
\dontrun{
q <- opq ("hampi india")
q <- add_osm_feature (q, key = "historic", value = "ruins")
osmdata_xml (q, filename = "hampi.osm")
}
}
\seealso{
Other extract: 
\code{\link{osmdata_data_frame}()},
\code{\link{osmdata_sc}()},
\code{\link{osmdata_sf}()},
\code{\link{osmdata_sp}()}
}
\concept{extract}
