% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiwave_diagram.R
\name{multiwave_diagram}
\alias{multiwave_diagram}
\title{Print Summary Diagram of Multiwave Object}
\usage{
multiwave_diagram(x, height = NULL, width = NULL)
}
\arguments{
\item{x}{An object of class \code{multiwave}.}

\item{height}{The height in pixels of the diagram. Defaults to \code{NULL}
, which produces default height.}

\item{width}{The width in pixels of the diagram. Defaults to \code{NULL},
which produces the default width.}
}
\value{
Returns an object of class \code{htmlwidget}
displaying the structure of the \code{x}.
}
\description{
Takes a multiwave object as input and plots a diagram of its structure
in the plotting window using \code{grViz()} from the \code{DiagrammeR}
package. Red boxes indicate slots that have not yet been
filled, blue boxes indicate that the slot is filled.
}
\examples{
MySurvey <- multiwave(phases = 2, waves = c(1, 3))
multiwave_diagram(MySurvey)
}
